/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener;

import de.ponton.xmlpipe.rest.listener.ListenerConfigurationDto;
import de.ponton.xmlpipe.rest.listener.ListenerConfigurationDtoIpCollisionConstraint;
import de.ponton.xmlpipe.rest.listener.common.ListenerIpConnectionDto;
import de.ponton.xmlpipe.rest.listener.ftp.FtpDataConnectionDto;
import de.ponton.xmlpipe.rest.listener.ftp.FtpListenerDto;
import de.ponton.xmlpipe.rest.listener.http.HttpListenerDto;
import de.ponton.xmlpipe.rest.listener.http.HttpsListenerDto;
import de.ponton.xmlpipe.rest.listener.http.WebListenerDto;
import de.ponton.xmlpipe.rest.listener.proxy.ListenerProxyDto;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ListenerConfigurationDtoIpCollisionValidator
implements ConstraintValidator<ListenerConfigurationDtoIpCollisionConstraint, ListenerConfigurationDto> {
    public boolean isValid(ListenerConfigurationDto value, ConstraintValidatorContext context) {
        WebListenerDto webListenerDto = value.getWebListener();
        ArrayList<ListenerIpConnectionDto> connections = new ArrayList<ListenerIpConnectionDto>();
        ArrayList collisions = new ArrayList();
        try {
            FtpListenerDto ftpListenerDto;
            ListenerProxyDto listenerProxyDto;
            ListenerIpConnectionDto connectionDto;
            if (webListenerDto != null) {
                HttpsListenerDto httpsListenerDto;
                HttpListenerDto httpListenerDto = webListenerDto.getHttpListener();
                if (httpListenerDto != null && httpListenerDto.isEnabled()) {
                    connections.add(httpListenerDto.getConnection());
                }
                if ((httpsListenerDto = webListenerDto.getHttpsListener()) != null && httpsListenerDto.isEnabled()) {
                    connectionDto = httpsListenerDto.getConnection();
                    this.findCollision(connectionDto, connections).ifPresent(collisions::add);
                    connections.add(connectionDto);
                }
            }
            if ((listenerProxyDto = value.getListenerProxy()) != null && listenerProxyDto.isEnabled()) {
                ListenerIpConnectionDto connectionDto2 = listenerProxyDto.getConnection();
                this.findCollision(connectionDto2, connections).ifPresent(collisions::add);
                connections.add(connectionDto2);
            }
            if ((ftpListenerDto = value.getFtpListener()) != null && ftpListenerDto.isEnabled()) {
                connectionDto = ftpListenerDto.getServiceConnection();
                this.findCollision(connectionDto, connections).ifPresent(collisions::add);
                connections.add(connectionDto);
                FtpDataConnectionDto dataConnectionDto = ftpListenerDto.getDataConnection();
                this.findFtpDataConnectionCollision(dataConnectionDto, connections).ifPresent(collisions::add);
            }
            return collisions.isEmpty();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    private Optional<ListenerIpConnectionDto> findCollision(ListenerIpConnectionDto connectionToCheck, List<ListenerIpConnectionDto> connections) {
        return connections.stream().filter(connection -> (connectionToCheck.getIp().equals(connection.getIp()) || connectionToCheck.getIp().equals("*") || connection.getIp().equals("*")) && connectionToCheck.getPort().equals(connection.getPort())).findFirst();
    }

    private Optional<ListenerIpConnectionDto> findFtpDataConnectionCollision(FtpDataConnectionDto connectionToCheck, List<ListenerIpConnectionDto> connections) {
        return connections.stream().filter(connection -> (connectionToCheck.getIp().equals(connection.getIp()) || connectionToCheck.getIp().equals("*") || connection.getIp().equals("*")) && connection.getPort() >= connectionToCheck.getFromPort() && connection.getPort() <= connectionToCheck.getToPort()).findFirst();
    }
}

