/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.jwt;

import de.ponton.xmlpipe.rest.jwt.JwtTokenUtil;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TokenBlacklistService {
    private final JwtTokenUtil jwtTokenUtil;
    private final Map<String, OffsetDateTime> blacklist = Collections.synchronizedMap(new HashMap());

    public TokenBlacklistService(@Qualifier(value="restScheduledExecutorService") ScheduledExecutorService restScheduledExecutorService, JwtTokenUtil jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
        restScheduledExecutorService.scheduleAtFixedRate(this::purgeBlacklist, Duration.ofMinutes(1L).toMillis(), 1L, TimeUnit.MINUTES);
    }

    public void purgeBlacklist() {
        List<String> collect = this.blacklist.entrySet().stream().filter(e -> ((OffsetDateTime)e.getValue()).isBefore(OffsetDateTime.now())).map(Map.Entry::getKey).toList();
        collect.forEach(this.blacklist::remove);
    }

    public void blacklistToken(String token) {
        this.blacklist.put(token, this.jwtTokenUtil.getTokenExpirationDate(token));
    }

    public boolean isBlacklisted(String token) {
        return this.blacklist.containsKey(token);
    }
}

