/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.jwt;

import de.ponton.xmlpipe.rest.jwt.JwtTokenUtil;
import de.ponton.xmlpipe.rest.jwt.TokenBlacklistService;
import de.pontonconsulting.xmlpipe.config.SSLKeystoreBean;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerUserDAO;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.MissingClaimException;
import io.jsonwebtoken.security.SecurityException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtRequestFilter
extends OncePerRequestFilter {
    private static final String JAVAX_SERVLET_REQUEST_X509CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    private static final Logger LOG = LogManager.getLogger((String)("Audit." + JwtRequestFilter.class.getName()));
    private final PontonUserDetailsServiceImpl jwtUserDetailsService;
    private final JwtTokenUtil jwtTokenUtil;
    private final MessengerUserDAO messengerUserDAO;
    private final TokenBlacklistService tokenBlacklistService;
    private final SSLKeystoreBean keystoreBean;

    public JwtRequestFilter(PontonUserDetailsServiceImpl jwtUserDetailsService, JwtTokenUtil jwtTokenUtil, MessengerUserDAO messengerUserDAO, TokenBlacklistService tokenBlacklistService, SSLKeystoreBean keystoreBean) {
        this.jwtUserDetailsService = jwtUserDetailsService;
        this.jwtTokenUtil = jwtTokenUtil;
        this.messengerUserDAO = messengerUserDAO;
        this.tokenBlacklistService = tokenBlacklistService;
        this.keystoreBean = keystoreBean;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        block10: {
            Optional<UserDetails> certAuthUser = this.checkCertificateAuthentication(request);
            if (certAuthUser.isPresent()) {
                UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)certAuthUser.get(), null, certAuthUser.get().getAuthorities());
                usernamePasswordAuthenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                LOG.info("{'{}', '{}' -> '{}'} {} {}", (Object)certAuthUser.get().getUsername(), (Object)request.getRemoteAddr(), (Object)request.getLocalAddr(), (Object)request.getMethod(), (Object)request.getPathInfo());
                SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
            } else {
                String requestTokenHeader = request.getHeader("Authorization");
                if (requestTokenHeader != null && requestTokenHeader.startsWith("Bearer ")) {
                    String jwtToken = requestTokenHeader.substring(7);
                    try {
                        if (!this.tokenBlacklistService.isBlacklisted(jwtToken)) {
                            String username = this.jwtTokenUtil.getUsernameFromToken(jwtToken, request.getRemoteAddr(), request.getHeader("X-Forwarded-For"));
                            MessengerUser userDetails = this.jwtUserDetailsService.loadUserByUsername(username);
                            Set<SimpleGrantedAuthority> authorities = this.jwtUserDetailsService.isTwoFactorsEnforced() && !this.jwtUserDetailsService.isTotpEnabled(username) ? Set.of(new SimpleGrantedAuthority("USER_GET"), new SimpleGrantedAuthority("USER_LANGUAGE_GET"), new SimpleGrantedAuthority("USER_LANGUAGE_PUT"), new SimpleGrantedAuthority("USER_LANGUAGE_DELETE"), new SimpleGrantedAuthority("USER_PASSWORD_POST"), new SimpleGrantedAuthority("USER_GENERATE_TOTP_SECRET_POST"), new SimpleGrantedAuthority("USER_ENABLE_TOTP_POST"), new SimpleGrantedAuthority("USER_DISABLE_TOTP_POST"), new SimpleGrantedAuthority("USER_IS_TOTP_ENABLED_GET")) : userDetails.getAuthorities();
                            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, (Collection)authorities);
                            LOG.info("{'{}', '{}' -> '{}'} {} {}", (Object)userDetails.getUsername(), (Object)request.getRemoteAddr(), (Object)request.getLocalAddr(), (Object)request.getMethod(), (Object)request.getPathInfo());
                            usernamePasswordAuthenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                            SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
                            break block10;
                        }
                        LOG.info("blacklisted JsonWebToken received: {}", (Object)jwtToken);
                    }
                    catch (ExpiredJwtException e) {
                        LOG.error("JWT Token has expired. Message is: {}", (Object)e.getMessage());
                    }
                    catch (SecurityException e) {
                        LOG.error("JWT Token signature incorrect. Message is: {}", (Object)e.getMessage());
                    }
                    catch (IncorrectClaimException | MissingClaimException e) {
                        LOG.error("JWT Token has invalid claims. Message is: {}", (Object)e.getMessage());
                    }
                    catch (Exception e) {
                        LOG.error("Invalid JWT token. ", (Throwable)e);
                    }
                } else {
                    LOG.info("{'', '{}' -> '{}'} {} {} Authentication header with Bearer value is missing. Header={}", (Object)request.getRemoteAddr(), (Object)request.getLocalAddr(), (Object)request.getMethod(), (Object)request.getPathInfo(), (Object)requestTokenHeader);
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private Optional<UserDetails> checkCertificateAuthentication(HttpServletRequest request) throws ServletException {
        block5: {
            try {
                if (request.isSecure()) {
                    X509Certificate[] certChain = (X509Certificate[])request.getAttribute(JAVAX_SERVLET_REQUEST_X509CERTIFICATE);
                    if (certChain == null || certChain.length == 0) {
                        return Optional.empty();
                    }
                    Enumeration<String> sslAliases = this.keystoreBean.getTrustSSLAliases();
                    while (sslAliases.hasMoreElements()) {
                        String alias = sslAliases.nextElement();
                        X509Certificate certificate = this.keystoreBean.getSSLTrustCertificate(alias);
                        if (!certificate.equals(certChain[0])) continue;
                        return Optional.ofNullable(this.messengerUserDAO.getUser(alias));
                    }
                    break block5;
                }
                return Optional.empty();
            }
            catch (Exception e) {
                this.logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return Optional.empty();
    }
}

