/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.hotfolder;

import de.ponton.xmlpipe.rest.hotfolder.HotFolderDto;
import de.ponton.xmlpipe.rest.hotfolder.HotFolderDtoFactory;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderConfiguration;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class HotFolderService {
    private final HotFolderConfiguration hotFolderConfiguration;
    private final HotFolderDtoFactory hotFolderDtoFactory;

    public HotFolderService(HotFolderConfiguration hotFolderConfiguration, HotFolderDtoFactory hotFolderDtoFactory) {
        this.hotFolderConfiguration = hotFolderConfiguration;
        this.hotFolderDtoFactory = hotFolderDtoFactory;
    }

    private List<HotFolderDto> getAllHotFolders() throws JAXBException {
        ArrayList<HotFolderDto> hotFolderInfoList = new ArrayList<HotFolderDto>();
        for (String id : this.hotFolderConfiguration.getHotFolderIDs()) {
            Optional.ofNullable(this.hotFolderConfiguration.getHotFolder(id)).map(this.hotFolderDtoFactory::create).ifPresent(hotFolderInfoList::add);
        }
        return hotFolderInfoList;
    }

    public List<String> getFilteredOutboxFolders(String excludeAdapterId) throws JAXBException {
        return this.getAllHotFolders().stream().filter(hotFolderDto -> !hotFolderDto.getAdapterId().equals(excludeAdapterId)).map(HotFolderDto::getOutboxFolder).distinct().toList();
    }
}

