/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.hotfolder;

import de.ponton.xmlpipe.rest.hotfolder.HotFolderDto;
import de.ponton.xmlpipe.rest.hotfolder.HotFolderOutboxConstraint;
import de.ponton.xmlpipe.rest.hotfolder.HotFolderService;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import jakarta.xml.bind.JAXBException;
import java.util.List;

@SupportedValidationTarget(value={ValidationTarget.ANNOTATED_ELEMENT})
public class HotFolderOutboxValidator
implements ConstraintValidator<HotFolderOutboxConstraint, HotFolderDto> {
    private final HotFolderService hotFolderService;

    public HotFolderOutboxValidator(HotFolderService hotFolderService) {
        this.hotFolderService = hotFolderService;
    }

    public boolean isValid(HotFolderDto hotFolderDto, ConstraintValidatorContext context) {
        List<String> existingFilteredOutboxFolders;
        try {
            existingFilteredOutboxFolders = this.hotFolderService.getFilteredOutboxFolders(hotFolderDto.getAdapterId());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not get Hotfolders from Service", e);
        }
        return !existingFilteredOutboxFolders.contains(hotFolderDto.getOutboxFolder());
    }
}

