/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.exception;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import de.ponton.xmlpipe.rest.authentication.PasswordReuseException;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.security.acegi.Enforced2faException;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import de.pontonconsulting.xmlpipe.security.acegi.UserCredentialsExpiredException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RestResponseEntityExceptionHandler {
    private final Logger LOG = LogManager.getLogger((String)("Messenger." + RestResponseEntityExceptionHandler.class.getName()));
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + RestResponseEntityExceptionHandler.class.getName()));
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final PontonUserDetailsServiceImpl pontonUserDetailsService;

    public RestResponseEntityExceptionHandler(ExceptionDtoFactory exceptionDtoFactory, PontonUserDetailsServiceImpl pontonUserDetailsService) {
        this.exceptionDtoFactory = exceptionDtoFactory;
        this.pontonUserDetailsService = pontonUserDetailsService;
    }

    @ExceptionHandler(value={IllegalArgumentException.class, InvalidFormatException.class, ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleBadRequest(Exception e) {
        this.LOG.error("Invalid request: {}", (Object)e.toString());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={LockedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleAccountLockedExceptions(Exception e) {
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={UserCredentialsExpiredException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleUserCredentialsExpiredExceptions(Exception e) {
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={PasswordReuseException.class, AccountStatusException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleAccountExceptions(Exception e) {
        AUDIT.info("account error: {}", (Object)e.toString());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleNotFoundRequest(Exception e) {
        this.LOG.error("Resource not found: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    ResponseEntity<ExceptionDto> onConstraintValidationException(ConstraintViolationException e) {
        this.LOG.error("Constraint violation detected. Error: {}", (Object)e.getMessage());
        ExceptionDto error = this.exceptionDtoFactory.create((Throwable)e);
        e.getConstraintViolations().forEach(error::addViolation);
        return ResponseEntity.badRequest().body((Object)error);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    ResponseEntity<ExceptionDto> onMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        this.LOG.error("Method arguments are not valid. Error: {}", (Object)e.getMessage());
        ExceptionDto error = this.exceptionDtoFactory.create((Throwable)e);
        e.getAllErrors().stream().map(fieldError -> (ConstraintViolation)fieldError.unwrap(ConstraintViolation.class)).forEach(error::addViolation);
        return ResponseEntity.badRequest().body((Object)error);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> handleInternalServerError(RuntimeException e) {
        this.LOG.error("Unexpected runtime error:", (Throwable)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> handleInternalServerError(Exception e) {
        this.LOG.error("Unexpected error: ", (Throwable)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public ResponseEntity<ExceptionDto> handleAccessDeniedException(AccessDeniedException e) {
        MessengerUser user = (MessengerUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        AUDIT.info("User {} is not authorized to call REST endpoint: {}", (Object)user, (Object)e.getMessage());
        if (!user.getTotpEnabled() && this.pontonUserDetailsService.isTwoFactorsEnforced()) {
            return new ResponseEntity((Object)this.exceptionDtoFactory.create((Throwable)((Object)new Enforced2faException("2fa is enforced"))), (HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)this.exceptionDtoFactory.create((Throwable)e), (HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseEntity<ExceptionDto> handleAuthenticationException(AuthenticationException e) {
        AUDIT.info("authorization is required to call REST endpoint: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create((Throwable)e), (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }
}

