/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.transport;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Defines a 'Transport channel' over which messages can be sent.")
public class TransportDto {
    @Size(max=256)
    @Pattern(regexp="(http://|https://|ftp://|ftps://|smime:|mailto:).*")
    @Schema(description="The url of this Transport")
    @NotBlank
    @TrimmedField
    private @Size(max=256) @Pattern(regexp="(http://|https://|ftp://|ftps://|smime:|mailto:).*") @NotBlank String url;
    @Schema(description="Determines if this is the preferred transport URL (true) or not (false)")
    @NotNull
    private Boolean preferred;
    @Schema(description="Determines if this a fallback transport URL (true) or not (false)")
    @NotNull
    private Boolean fallback;

    public String getUrl() {
        return this.url;
    }

    public TransportDto setUrl(String url) {
        this.url = url;
        return this;
    }

    public Boolean getPreferred() {
        return this.preferred;
    }

    public TransportDto setPreferred(Boolean preferred) {
        this.preferred = preferred;
        return this;
    }

    public Boolean getFallback() {
        return this.fallback;
    }

    public TransportDto setFallback(Boolean fallback) {
        this.fallback = fallback;
        return this;
    }
}

