/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate.validation;

import de.ponton.xmlpipe.rest.cpp.certificate.validation.KeyPairPasswordConstraint;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.security.cert.X509Certificate;
import java.util.Objects;

@SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
public class KeyPairPasswordValidator
implements ConstraintValidator<KeyPairPasswordConstraint, Object[]> {
    private final Profiles profiles;

    public KeyPairPasswordValidator(Profiles profiles) {
        this.profiles = profiles;
    }

    public boolean isValid(Object[] value, ConstraintValidatorContext context) {
        try {
            CppPartner partner = this.profiles.getProfileForLocalId(value[0].toString(), true);
            X509Certificate certificate = partner.getX509Certificate(value[1].toString());
            String certAlias = partner.buildAliasForPartnerCertificate(certificate);
            String privateKeyPassword = partner.getPrivateKeyPassword(certAlias);
            return Objects.equals(value[2], privateKeyPassword);
        }
        catch (ProfileException e) {
            throw new ResourceNotFoundException(e);
        }
    }
}

