/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate.validation;

import de.ponton.xmlpipe.rest.cpp.certificate.validation.CertificateExpirationConstraint;
import de.ponton.xmlpipe.rest.cpp.certificate.validation.NotExpiredCertificate;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.validation.CrossParameterValidator;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.reflect.Field;
import java.security.cert.CertificateException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
public class CertificateExpirationValidator
implements ConstraintValidator<CertificateExpirationConstraint, Object[]> {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final CrossParameterValidator crossParameterValidator;
    private final Profiles profiles;
    private String validationMessage;

    public CertificateExpirationValidator(CrossParameterValidator crossParameterValidator, Profiles profiles) {
        this.crossParameterValidator = crossParameterValidator;
        this.profiles = profiles;
    }

    private CppPartner resolveResource(String id) {
        try {
            return this.profiles.getProfileForLocalId(id, true);
        }
        catch (ProfileException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    public void initialize(CertificateExpirationConstraint constraintAnnotation) {
        this.validationMessage = constraintAnnotation.message();
    }

    public boolean isValid(Object[] value, ConstraintValidatorContext context) {
        return this.crossParameterValidator.validate(value, context, this.validationMessage, this::validateField, NotExpiredCertificate.class);
    }

    protected boolean validateField(Field field, Object ... args) {
        Object dto = args[1];
        try {
            CppPartner partner = this.resolveResource(args[0].toString());
            if (field.get(dto) != null) {
                partner.getX509Certificate(field.get(dto).toString()).checkValidity();
            }
        }
        catch (IllegalAccessException e) {
            this.log.error(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (CertificateIdNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (CertificateException e) {
            return false;
        }
        return true;
    }
}

