/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.ponton.xmlpipe.rest.cpp.validation.RequiredFieldForLocalPartner;
import de.ponton.xmlpipe.rest.jackson.ObfuscatedField;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.X509CertificateConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Describes a X509 certificate to be imported")
public class ImportCertificateDto {
    @NotBlank
    @X509CertificateConstraint
    @Schema(description="The certificate as Base64 encoded String")
    @TrimmedField
    private String certificateBase64;
    @Schema(description="The password for the private key of this certificate. Required only for local partner.")
    @RequiredFieldForLocalPartner
    @ObfuscatedField
    private String password;

    public String getCertificateBase64() {
        return this.certificateBase64;
    }

    public ImportCertificateDto setCertificateBase64(String certificateBase64) {
        this.certificateBase64 = certificateBase64;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ImportCertificateDto setPassword(String password) {
        this.password = password;
        return this;
    }
}

