/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.ponton.xmlpipe.rest.cpp.certificate.BDEWCertificateRequest;
import de.ponton.xmlpipe.rest.cpp.certificate.BDEWCertificateRequestFactory;
import de.ponton.xmlpipe.rest.cpp.certificate.CertificateRequestDto;
import de.ponton.xmlpipe.rest.cpp.certificate.CertificateRequestFactory;
import de.ponton.xmlpipe.rest.cpp.certificate.CreateBDEWCertificateRequestDto;
import de.ponton.xmlpipe.rest.cpp.certificate.CreateCertificateRequestDto;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.adapter.IEventNotifier;
import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertificateUpdateAdapter;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.admintool.messenger.ssl.certificate.KeyPairAlgorithm;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.security.CertificateExpireCheckTask;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.CertificateRequest;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.PublicKeyAlgorithmUtility;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.OperatorCreationException;
import org.springframework.stereotype.Component;

@Component
public class CertificateRequestService {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + String.valueOf(CertificateRequestService.class)));
    private final ActivationControl activationControl;
    private final Profiles profiles;
    private final CertificateReader certificate;
    private final KeystoreBean keystore;
    private final CertificateUtility certificateUtility;
    private final IEventNotifier eventNotifier;
    private final CertificateExpireCheckTask certificateExpireCheckTask;
    private final AS4CertificateUpdateAdapter as4CertificateUpdateAdapter;
    private final CertificateRequestFactory certificateRequestFactory;
    private final PublicKeyAlgorithmUtility publicKeyAlgorithmUtility;
    private final BDEWCertificateRequestFactory bdewCertificateRequestFactory;
    private final MessengerConfig messengerConfig;

    public CertificateRequestService(ActivationControl activationControl, Profiles profiles, CertificateReader certificate, KeystoreBean keystoreBean, CertificateUtility certificateUtility, IEventNotifier eventNotifier, CertificateExpireCheckTask certificateExpireCheckTask, AS4CertificateUpdateAdapter as4CertificateUpdateAdapter, CertificateRequestFactory certificateRequestFactory, PublicKeyAlgorithmUtility publicKeyAlgorithmUtility, MessengerConfig messengerConfig, BDEWCertificateRequestFactory bdewCertificateRequestFactory) {
        this.activationControl = activationControl;
        this.profiles = profiles;
        this.certificate = certificate;
        this.keystore = keystoreBean;
        this.certificateUtility = certificateUtility;
        this.eventNotifier = eventNotifier;
        this.certificateExpireCheckTask = certificateExpireCheckTask;
        this.as4CertificateUpdateAdapter = as4CertificateUpdateAdapter;
        this.certificateRequestFactory = certificateRequestFactory;
        this.publicKeyAlgorithmUtility = publicKeyAlgorithmUtility;
        this.messengerConfig = messengerConfig;
        this.bdewCertificateRequestFactory = bdewCertificateRequestFactory;
    }

    public CertificateRequest requestCertificate(CppPartner partner, CreateCertificateRequestDto createCertificateRequestDto) throws GeneralSecurityException, InstallCertException, ProfileException, AgreementException, IOException {
        KeyPairAlgorithm keyPairAlgorithm = createCertificateRequestDto.getKeyPair();
        KeyPair keyPair = this.certificate.generateKeyPair(keyPairAlgorithm.getAlgorithm(), keyPairAlgorithm.getLength());
        CertificateRequest certRequest = this.createCertificateRequest(keyPair, createCertificateRequestDto);
        this.storeCertificateRequest(partner, createCertificateRequestDto.getPassword(), keyPair, certRequest);
        return certRequest;
    }

    public BDEWCertificateRequest requestBDEWCertificate(CppPartner partner, CreateBDEWCertificateRequestDto createBDEWCertificateRequestDto) throws GeneralSecurityException, InstallCertException, ProfileException, AgreementException, IOException, OperatorCreationException, CRMFException, CMSException {
        Object clientCert;
        X500Name subject;
        RDN[] serialNumbers;
        HashMap<CertificateRequest, PrivateKey> certReqMsgs = new HashMap<CertificateRequest, PrivateKey>();
        KeyPairAlgorithm algorithm = KeyPairAlgorithm.brainpoolP256r1;
        SignCertInfo bdewSignCertificate = this.findBDEWSignCertificate(partner);
        int sequenceNumber = 1;
        if (bdewSignCertificate != null && bdewSignCertificate.getCertificateChain() != null && bdewSignCertificate.getCertificateChain().length > 0 && (serialNumbers = (subject = X500Name.getInstance((Object)((X509Certificate)(clientCert = bdewSignCertificate.getCertificateChain()[0])).getSubjectX500Principal().getEncoded())).getRDNs(BCStyle.SERIALNUMBER)).length > 0) {
            try {
                sequenceNumber = Integer.parseInt(IETFUtils.valueToString((ASN1Encodable)serialNumbers[0].getFirst().getValue())) + 1;
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not get SERIALNUMBER from existing certificate.", (Throwable)e);
            }
        }
        for (BDEWCertificateExtension bdewCertificateExtension : BDEWCertificateExtension.values()) {
            KeyPair keyPair = this.certificate.generateKeyPair(algorithm.getAlgorithm(), algorithm.getLength());
            CertificateRequest certRequest = this.createBDEWCertificateRequest(sequenceNumber, keyPair, createBDEWCertificateRequestDto, bdewCertificateExtension);
            this.storeCertificateRequest(partner, createBDEWCertificateRequestDto.getPassword(), keyPair, certRequest);
            certReqMsgs.put(certRequest, keyPair.getPrivate());
        }
        byte[] bdewFormatedData = this.bdewCertificateRequestFactory.createBDEWCertificateRequest(certReqMsgs, bdewSignCertificate);
        return new BDEWCertificateRequest(List.copyOf(certReqMsgs.keySet()), bdewFormatedData);
    }

    private SignCertInfo findBDEWSignCertificate(CppPartner cppPartner) throws CertificateException, ProfileException {
        Date latestIssueDate = new Date(0L);
        String selectedCertificateId = null;
        for (X509Certificate x509Cert : cppPartner.getAllValidCertificates()) {
            boolean[] keyUsage = x509Cert.getKeyUsage();
            boolean digitalSignatureEnabled = keyUsage != null && keyUsage.length != 0 && keyUsage[0];
            boolean missingExtendedKeyUsage = x509Cert.getExtendedKeyUsage() == null || x509Cert.getExtendedKeyUsage().isEmpty();
            String oValue = this.getO(x509Cert);
            String keyAlgorithm = this.certificateUtility.getKeyAlgorithmInfo(x509Cert);
            String certificateId = cppPartner.getCertificateId(x509Cert);
            Date issueDate = x509Cert.getNotBefore();
            String orgValue = this.messengerConfig.getProperty("ponton.messenger.bdew.csr.org");
            LOG.debug("Searching for BDEW signing certificate: certId:{}, keyAlgorithm:{}, oValue:{}, digitalSignatureEnabled:{}, missingExtendedKeyUsage:{}", (Object)certificateId, (Object)keyAlgorithm, (Object)oValue, (Object)digitalSignatureEnabled, (Object)missingExtendedKeyUsage);
            if (!"EC [brainpoolP256r1]".equals(keyAlgorithm) || !orgValue.equals(oValue) || !digitalSignatureEnabled || !missingExtendedKeyUsage) continue;
            LOG.debug("Found BDEW signing certificate with id:{} issuedDate:{}", (Object)certificateId, (Object)issueDate);
            if (!issueDate.after(latestIssueDate)) continue;
            latestIssueDate = issueDate;
            selectedCertificateId = certificateId;
        }
        if (selectedCertificateId != null) {
            LOG.debug("selected certificate with id:{} for signing.", selectedCertificateId);
            return cppPartner.getPrivateKey(selectedCertificateId);
        }
        return null;
    }

    private String getO(X509Certificate x509Certificate) throws CertificateEncodingException {
        X500Name x500name = new JcaX509CertificateHolder(x509Certificate).getSubject();
        if (x500name.getRDNs(BCStyle.O) == null || x500name.getRDNs(BCStyle.O).length == 0) {
            return null;
        }
        RDN o = x500name.getRDNs(BCStyle.O)[0];
        return IETFUtils.valueToString((ASN1Encodable)o.getFirst().getValue());
    }

    public String installCertificate(CppPartner partner, X509Certificate certificate, String password) throws ProfileException, GeneralSecurityException, InstallCertException, AgreementException {
        String certId = this.installCertificate(certificate, partner, password);
        this.certificateExpireCheckTask.checkForExpiredPartnerCertificates(partner);
        this.profiles.partnerCertificateUpdated(partner);
        if (partner.getAllValidCertificates().size() > 1) {
            this.as4CertificateUpdateAdapter.sendAS4CertificateUpdateRequestMessage(partner, certId);
        }
        return certId;
    }

    public List<CertificateRequestDto> getAllCertificateRequestsForLocalId(String localId) throws ProfileException, IOException {
        CppPartner partner = this.profiles.getProfileForLocalId(localId, true);
        List<CertificateRequest> allCertificateRequests = partner.getAllCertificateRequests();
        ArrayList<CertificateRequestDto> certificateRequestDtoList = new ArrayList<CertificateRequestDto>();
        for (CertificateRequest certificateRequest : allCertificateRequests) {
            CertificateRequestDto certificateRequestDto = new CertificateRequestDto();
            certificateRequestDto.setId(certificateRequest.getId());
            certificateRequestDto.setCertificateRequest(certificateRequest.getPEM());
            certificateRequestDto.setSubject(certificateRequest.getSubject());
            String keyAlgorithmInfo = this.publicKeyAlgorithmUtility.getKeyAlgorithmInfoForCertificateRequest(certificateRequest);
            certificateRequestDto.setKeyPairAlgo(keyAlgorithmInfo);
            certificateRequestDtoList.add(certificateRequestDto);
        }
        return certificateRequestDtoList;
    }

    private CertificateRequest createBDEWCertificateRequest(int sequenceNumber, KeyPair keyPair, CreateBDEWCertificateRequestDto createBDEWCertificateRequestDto, BDEWCertificateExtension bdewCertificateExtension) throws InstallCertException, IOException {
        try {
            X500NameBuilder nameBuilder = new X500NameBuilder(X500Name.getDefaultStyle());
            nameBuilder.addRDN(BCStyle.SERIALNUMBER, String.valueOf(sequenceNumber));
            nameBuilder.addRDN(BCStyle.CN, createBDEWCertificateRequestDto.getOrg() + this.messengerConfig.getProperty("ponton.messenger.bdew.csr.suffix") + (String)(StringUtils.isNotBlank((CharSequence)createBDEWCertificateRequestDto.getSuffix()) ? "." + createBDEWCertificateRequestDto.getSuffix() : ""));
            nameBuilder.addRDN(BCStyle.O, this.messengerConfig.getProperty("ponton.messenger.bdew.csr.org"));
            nameBuilder.addRDN(BCStyle.C, createBDEWCertificateRequestDto.getC());
            if (StringUtils.isNotBlank((CharSequence)createBDEWCertificateRequestDto.getOu())) {
                nameBuilder.addRDN(BCStyle.OU, createBDEWCertificateRequestDto.getOu());
            }
            if (StringUtils.isNotBlank((CharSequence)createBDEWCertificateRequestDto.getL())) {
                nameBuilder.addRDN(BCStyle.L, createBDEWCertificateRequestDto.getL());
            }
            if (StringUtils.isNotBlank((CharSequence)createBDEWCertificateRequestDto.getSt())) {
                nameBuilder.addRDN(BCStyle.ST, createBDEWCertificateRequestDto.getSt());
            }
            if (StringUtils.isNotBlank((CharSequence)createBDEWCertificateRequestDto.getStreet())) {
                nameBuilder.addRDN(BCStyle.STREET, createBDEWCertificateRequestDto.getStreet());
            }
            if (StringUtils.isNotBlank((CharSequence)createBDEWCertificateRequestDto.getPostalCode())) {
                nameBuilder.addRDN(BCStyle.POSTAL_CODE, createBDEWCertificateRequestDto.getPostalCode());
            }
            X500Name subject = nameBuilder.build();
            KeyUsage keyUsage = null;
            ExtendedKeyUsage extendedKeyUsage = null;
            ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
            switch (bdewCertificateExtension.ordinal()) {
                case 1: {
                    keyUsage = new KeyUsage(40);
                    generalNames.add(new GeneralName(1, createBDEWCertificateRequestDto.getEmail()));
                    generalNames.add(new GeneralName(6, createBDEWCertificateRequestDto.getUrl()));
                    break;
                }
                case 0: {
                    keyUsage = new KeyUsage(128);
                    generalNames.add(new GeneralName(1, createBDEWCertificateRequestDto.getEmail()));
                    generalNames.add(new GeneralName(6, createBDEWCertificateRequestDto.getUrl()));
                    break;
                }
                case 2: {
                    keyUsage = new KeyUsage(128);
                    extendedKeyUsage = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth});
                    generalNames.add(new GeneralName(1, createBDEWCertificateRequestDto.getEmail()));
                    String host = URI.create(createBDEWCertificateRequestDto.getUrl()).getHost();
                    if (host == null) {
                        throw new IllegalArgumentException("The host is not defined in the URL.");
                    }
                    generalNames.add(new GeneralName(2, host));
                    generalNames.add(new GeneralName(6, createBDEWCertificateRequestDto.getUrl()));
                }
            }
            return this.certificateRequestFactory.createCertificateRequest(this.certificateUtility.generateTempAlias(), subject, keyUsage, extendedKeyUsage, keyPair.getPublic(), keyPair.getPrivate(), new GeneralNames(generalNames.toArray(new GeneralName[0])));
        }
        catch (GeneralSecurityException | OperatorCreationException e) {
            InstallCertException ce = new InstallCertException(32013, new String[]{e.getMessage()}, e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    private CertificateRequest createCertificateRequest(KeyPair keyPair, CreateCertificateRequestDto createCertificateRequestDto) throws InstallCertException {
        try {
            X500NameBuilder nameBuilder = new X500NameBuilder(X500Name.getDefaultStyle());
            nameBuilder.addRDN(BCStyle.CN, createCertificateRequestDto.getCn());
            nameBuilder.addRDN(BCStyle.O, createCertificateRequestDto.getO());
            nameBuilder.addRDN(BCStyle.C, createCertificateRequestDto.getC());
            nameBuilder.addRDN(BCStyle.EmailAddress, createCertificateRequestDto.getEmail());
            if (StringUtils.isNotBlank((CharSequence)createCertificateRequestDto.getOu())) {
                nameBuilder.addRDN(BCStyle.OU, createCertificateRequestDto.getOu());
            }
            if (StringUtils.isNotBlank((CharSequence)createCertificateRequestDto.getL())) {
                nameBuilder.addRDN(BCStyle.L, createCertificateRequestDto.getL());
            }
            if (StringUtils.isNotBlank((CharSequence)createCertificateRequestDto.getSt())) {
                nameBuilder.addRDN(BCStyle.ST, createCertificateRequestDto.getSt());
            }
            if (StringUtils.isNotBlank((CharSequence)createCertificateRequestDto.getPhone())) {
                nameBuilder.addRDN(BCStyle.TELEPHONE_NUMBER, createCertificateRequestDto.getPhone());
            }
            X500Name subject = nameBuilder.build();
            Map<String, String> extensions = null;
            if (createCertificateRequestDto.getExtensions()) {
                extensions = this.buildExtensions();
            }
            return this.certificateRequestFactory.createCertificateRequest(this.certificateUtility.generateTempAlias(), subject, extensions, keyPair);
        }
        catch (GeneralSecurityException | OperatorCreationException e) {
            InstallCertException ce = new InstallCertException(32013, new String[]{e.getMessage()}, e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    private Map<String, String> buildExtensions() {
        HashMap<String, String> extensions = new HashMap<String, String>(3);
        extensions.put("1.3.6.1.4.1.14136.3.1", Constants.getXP_VERSION());
        String testValue = this.activationControl.isLicensed() ? "false" : "true";
        extensions.put("1.3.6.1.4.1.14136.3.2", testValue);
        extensions.put("1.3.6.1.4.1.14136.3.3", "partner");
        return extensions;
    }

    private void storeCertificateRequest(CppPartner partner, String password, KeyPair keyPair, CertificateRequest certificateRequest) throws GeneralSecurityException, ProfileException, IOException, AgreementException {
        PrivateKey privateKey = keyPair.getPrivate();
        partner.addCertificateRequest(privateKey, password, certificateRequest);
        partner.save(false, false, false, false, false);
    }

    private String installCertificate(X509Certificate certificate, CppPartner partner, String password) throws InstallCertException, GeneralSecurityException, ProfileStoreAccessException {
        this.keystore.getKeystore().checkCertificate(certificate);
        Set<X509Certificate> allPartnerCertificates = partner.getAllCertificates();
        for (X509Certificate partnerCert : allPartnerCertificates) {
            if (!this.certificateUtility.certificatesEqual(certificate, partnerCert)) continue;
            throw new InstallCertException(32017, "Certificate is already installed.");
        }
        String certId = this.updatePrivateKey(partner, password, certificate);
        partner.removeCertificateRequestData(certificate, password);
        partner.save();
        this.eventNotifier.partnerCertificateAdded(partner.getInternalId(), certificate, partner.isLocal());
        return certId;
    }

    private String updatePrivateKey(CppPartner partner, String password, X509Certificate cert) throws GeneralSecurityException, InstallCertException {
        PrivateKey tempPrivateKey = partner.findPrivateKey(cert);
        if (tempPrivateKey == null) {
            throw new InstallCertException(32003, "No matching private key found for local ID. A certificate must be requested first.");
        }
        return partner.addPrivateKey(cert, tempPrivateKey, password);
    }

    private static enum BDEWCertificateExtension {
        SIG,
        ENC,
        TLS;

    }
}

