/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp;

import de.ponton.xmlpipe.rest.cpp.PartnerListItemDto;
import de.pontonconsulting.xmlpipe.admintool.registry.index.IndexRecord;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class PartnerListItemDtoFactory {
    PartnerListItemDto createPartnerListItemDto(@Nullable Map<String, IndexRecord> profilesOnRegistry, PartnerProfile partner) {
        IndexRecord indexRecord;
        PartnerListItemDto itemDto = new PartnerListItemDto();
        itemDto.setId(partner.getPartnerId());
        itemDto.setDisplayName(partner.getDisplayName());
        itemDto.setRemote(partner.isRemote());
        partner.getBackendPartnerIds().stream().findFirst().ifPresent(backendPartnerId -> itemDto.setBackendId(backendPartnerId.getBackendPartnerId()));
        itemDto.setValid(partner.isValid());
        itemDto.setLastModified(partner.getLastChange());
        if (partner.getRegistryPath() != null && profilesOnRegistry != null && (indexRecord = profilesOnRegistry.get(partner.getRegistryPath())) != null) {
            itemDto.setOwner(indexRecord.getPath());
            itemDto.setSynced(indexRecord.getLastModifiedLong() == partner.getLastChange().toInstant().toEpochMilli());
        }
        return itemDto;
    }
}

