/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp;

import de.ponton.xmlpipe.rest.cpp.PartnerListItemDto;
import de.ponton.xmlpipe.rest.cpp.PartnerListItemDtoFactory;
import de.pontonconsulting.xmlpipe.admintool.registry.index.IndexRecord;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.integration.WebDavIntegration;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.security.acegi.ClientRoleService;
import io.swagger.v3.oas.annotations.Operation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/partnerlist"})
public class PartnerListController {
    public static final String DOCUMENTATION_TAG = "Partner List";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final PartnerProfileDAO partnerProfileDAO;
    private final WebDavIntegration webDavIntegration;
    private final PartnerListItemDtoFactory partnerListItemDtoFactory;
    private final ClientRoleService clientRoleService;

    public PartnerListController(PartnerProfileDAO partnerProfileDAO, WebDavIntegration webDavIntegration, PartnerListItemDtoFactory partnerListItemDtoFactory, ClientRoleService clientRoleService) {
        this.partnerProfileDAO = partnerProfileDAO;
        this.webDavIntegration = webDavIntegration;
        this.partnerListItemDtoFactory = partnerListItemDtoFactory;
        this.clientRoleService = clientRoleService;
    }

    @GetMapping(produces={"application/json; charset=UTF-8"})
    @Operation(summary="Get a list of all Partner profiles", description="Returns a list of all Partner profiles.", tags={"Partner List"})
    @Secured(value={"PARTNER_LIST_GET"})
    public ResponseEntity<List<PartnerListItemDto>> getAllPartners(Principal principal, @RequestParam(required=false) boolean filter) throws ProfileException {
        ArrayList<PartnerListItemDto> partnerList = new ArrayList<PartnerListItemDto>();
        Map<String, IndexRecord> profilesOnRegistry = this.getStringIndexRecordMap();
        for (PartnerProfile partner : this.partnerProfileDAO.getAllPartnerProfiles().stream().filter(p -> !filter || this.clientRoleService.verifyPartnerAccess(p.getPartnerId(), principal.getName())).toList()) {
            PartnerListItemDto itemDto = this.partnerListItemDtoFactory.createPartnerListItemDto(profilesOnRegistry, partner);
            partnerList.add(itemDto);
        }
        partnerList.sort(Comparator.comparing(PartnerListItemDto::getId));
        return ResponseEntity.ok(partnerList);
    }

    /*
     * Exception decompiling
     */
    private Map<String, IndexRecord> getStringIndexRecordMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private /* synthetic */ Map lambda$getStringIndexRecordMap$1() throws Exception {
        return this.webDavIntegration.getRegistryIndex(false);
    }
}

