/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp;

import de.ponton.xmlpipe.rest.IDtoCreateFactory;
import de.ponton.xmlpipe.rest.cpp.PartnerDto;
import de.ponton.xmlpipe.rest.cpp.identification.PartyIdDtoFactory;
import de.ponton.xmlpipe.rest.cpp.maintenance.MaintenancePeriodDto;
import de.ponton.xmlpipe.rest.cpp.transport.TransportDtoFactory;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.messenger.database.tables.RemoteMaintenanceIntervalDAO;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PartnerDtoFactory
implements IDtoCreateFactory<PartnerDto, CppPartner> {
    private final PartyIdDtoFactory partyIdDtoFactory;
    private final TransportDtoFactory transportDtoFactory;
    private final SchemataConfig schemataConfig;
    private final RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO;

    public PartnerDtoFactory(PartyIdDtoFactory partyIdDtoFactory, TransportDtoFactory transportDtoFactory, SchemataConfig schemataConfig, RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO) {
        this.partyIdDtoFactory = partyIdDtoFactory;
        this.transportDtoFactory = transportDtoFactory;
        this.schemataConfig = schemataConfig;
        this.remoteMaintenanceIntervalDAO = remoteMaintenanceIntervalDAO;
    }

    @Override
    public PartnerDto create(CppPartner partner) {
        PartnerDto partnerDto = new PartnerDto();
        partnerDto.setAllowCertificateUpdate(partner.isCertUpdateAllowed());
        partnerDto.setDisplayName(partner.getDisplayName());
        partnerDto.setBackendId(partner.getInternalId());
        partnerDto.setId(partner.getLocalId());
        partnerDto.setImported(partner.isRemote() && partner.getRemoteFile() != null && !partner.getRemoteFile().isBlank());
        partnerDto.setRemote(partner.isRemote());
        if (partner.getContactInformation() != null) {
            partnerDto.setName(partner.getContactInformation().getName());
            partnerDto.setPhone(partner.getContactInformation().getPhone());
            partnerDto.setEmail(partner.getContactInformation().getEmail());
        }
        partnerDto.setDefaultPackager(partner.getPreferredPackagingId());
        partnerDto.setAutomaticPartnerUpdate(partner.isAutoupdate());
        partnerDto.setAutomaticAgreementsUpdate(partner.isAgreementAutoupdate());
        partnerDto.setDisabled(partner.isDisabled());
        partnerDto.setPartyIds(partner.getPartyIdList().stream().map(this.partyIdDtoFactory::create).collect(Collectors.toList()));
        partnerDto.setTransports(partner.getTransportList().stream().map(this.transportDtoFactory::create).collect(Collectors.toList()));
        partnerDto.setNumberOfParallelDeliveries(partner.getNumberOfParallelDeliveries());
        partnerDto.setMessageTypeIds(this.getMessageTypeIds(partner));
        partnerDto.setMaintenancePeriods(this.remoteMaintenanceIntervalDAO.readAll(partner.getLocalId()).stream().map(interval -> new MaintenancePeriodDto().setStartDate(OffsetDateTime.ofInstant(Instant.ofEpochMilli(interval.getStartTime()), ZoneOffset.UTC)).setEndDate(OffsetDateTime.ofInstant(Instant.ofEpochMilli(interval.getEndTime()), ZoneOffset.UTC))).collect(Collectors.toList()));
        return partnerDto;
    }

    private List<String> getMessageTypeIds(CppPartner partner) {
        ArrayList<String> messageTypes = new ArrayList<String>();
        partner.getDocumentTypes().forEach(documentType -> {
            SchemaData schemaData = this.schemataConfig.getSchemaBySetTypeVersion(documentType.getSchemaSet(), documentType.getType(), documentType.getVersion());
            if (schemaData != null) {
                messageTypes.add(schemaData.getId());
            }
        });
        return messageTypes;
    }
}

