/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.validation;

import de.ponton.xmlpipe.rest.cpa.AgreementDto;
import de.ponton.xmlpipe.rest.cpa.validation.PartnerCertificate;
import de.ponton.xmlpipe.rest.cpa.validation.PartnerCertificateConstraint;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.validation.CrossParameterValidator;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.reflect.Field;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

@SupportedValidationTarget(value={ValidationTarget.ANNOTATED_ELEMENT})
public class PartnerCertificateValidator
implements ConstraintValidator<PartnerCertificateConstraint, AgreementDto> {
    private final Profiles profiles;
    private final CrossParameterValidator crossParameterValidator;
    private String validationMessage;

    public PartnerCertificateValidator(Profiles profiles, CrossParameterValidator crossParameterValidator) {
        this.profiles = profiles;
        this.crossParameterValidator = crossParameterValidator;
    }

    public boolean isValid(AgreementDto agreementDto, ConstraintValidatorContext context) {
        return this.crossParameterValidator.validate(new Object[]{agreementDto, agreementDto}, context, this.validationMessage, this::validate, PartnerCertificate.class);
    }

    private Boolean validate(Field field, Object[] objects) {
        AgreementDto agreementDto = (AgreementDto)objects[0];
        boolean remote = field.getAnnotation(PartnerCertificate.class).remote();
        try {
            CppPartner partner = this.profiles.getProfileForLocalId(remote ? agreementDto.getCommunicationPartnerId() : agreementDto.getOwnPartnerId(), true);
            Object certificateId = field.get(objects[1]);
            if (certificateId != null) {
                partner.getX509Certificate(certificateId.toString()).checkValidity();
            }
        }
        catch (CertificateIdNotFoundException | IllegalAccessException | CertificateExpiredException | CertificateNotYetValidException e) {
            return false;
        }
        catch (ProfileException e) {
            throw new ResourceNotFoundException(e);
        }
        return true;
    }

    public void initialize(PartnerCertificateConstraint constraintAnnotation) {
        this.validationMessage = constraintAnnotation.message();
    }
}

