/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.validation;

import de.ponton.xmlpipe.rest.cpa.packaging.as4.AgreementReferenceDto;
import de.ponton.xmlpipe.rest.cpa.validation.AgreementRefConstraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.net.URI;
import java.net.URISyntaxException;

public class AgreementRefValidator
implements ConstraintValidator<AgreementRefConstraint, AgreementReferenceDto> {
    public boolean isValid(AgreementReferenceDto agreementRef, ConstraintValidatorContext context) {
        if (agreementRef != null) {
            String as4AgreementRef = agreementRef.getValue();
            String as4AgreementRefType = agreementRef.getType();
            if (!(as4AgreementRef == null || as4AgreementRef.isBlank() || this.validURI(as4AgreementRef) || as4AgreementRefType != null && !as4AgreementRefType.isBlank())) {
                return false;
            }
        }
        return true;
    }

    private boolean validURI(String uri) {
        try {
            return new URI(uri).getScheme() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

