/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.modification.XmlModificationDto;
import de.ponton.xmlpipe.rest.cpa.processing.CompressPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.EncryptPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.ExpectCompressedPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.ExpectEncryptedPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.ExpectSignedPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.SignPayloadsDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="Processing options", name="Agreement.Processing")
public class ProcessingDto {
    @Valid
    private SignPayloadsDto signPayloads;
    @Valid
    private ExpectSignedPayloadsDto expectSignedPayloads;
    @Valid
    private CompressPayloadsDto compressPayloads;
    @Valid
    private ExpectCompressedPayloadsDto expectCompressedPayloads;
    @Schema(description="Enable xml validation for outgoing messages.")
    private boolean validateTransmittedPayloads;
    @Schema(description="Enable xml validation for incoming messages.")
    private boolean validateReceivedPayloads;
    @Valid
    private EncryptPayloadsDto encryptPayloads;
    @Valid
    private ExpectEncryptedPayloadsDto expectEncryptedPayloads;
    @Valid
    private XmlModificationDto modifySendingXmlPayloads;
    @Valid
    private XmlModificationDto modifyReceivedXmlPayloads;
    @Schema(description="converting transmitted payloads to the ENERGYlink format. It will apply XML signature and XML encryption.")
    private boolean createEnergylinkXmlFormat;
    @Schema(description="process received payloads in ENERGYlink format. It will process the XML signed and XML encrypted content..")
    private boolean processEnergylinkXmlFormat;
    @Schema(description="apply custom validation to received messages. it will have no effect if no custom validators are installed.")
    private boolean customValidationOnReceivedPayloads;
    @Schema(description="apply custom validation to transmitted messages. it will have no effect if no custom validators are installed.")
    private boolean customValidationOnTransmittedPayloads;

    public SignPayloadsDto getSignPayloads() {
        return this.signPayloads;
    }

    public ProcessingDto setSignPayloads(SignPayloadsDto signPayloads) {
        this.signPayloads = signPayloads;
        return this;
    }

    public ExpectSignedPayloadsDto getExpectSignedPayloads() {
        return this.expectSignedPayloads;
    }

    public ProcessingDto setExpectSignedPayloads(ExpectSignedPayloadsDto expectSignedPayloads) {
        this.expectSignedPayloads = expectSignedPayloads;
        return this;
    }

    public CompressPayloadsDto getCompressPayloads() {
        return this.compressPayloads;
    }

    public ProcessingDto setCompressPayloads(CompressPayloadsDto compressPayloads) {
        this.compressPayloads = compressPayloads;
        return this;
    }

    public ExpectCompressedPayloadsDto getExpectCompressedPayloads() {
        return this.expectCompressedPayloads;
    }

    public ProcessingDto setExpectCompressedPayloads(ExpectCompressedPayloadsDto expectCompressedPayloads) {
        this.expectCompressedPayloads = expectCompressedPayloads;
        return this;
    }

    public boolean isValidateTransmittedPayloads() {
        return this.validateTransmittedPayloads;
    }

    public ProcessingDto setValidateTransmittedPayloads(boolean validateTransmittedPayloads) {
        this.validateTransmittedPayloads = validateTransmittedPayloads;
        return this;
    }

    public boolean isValidateReceivedPayloads() {
        return this.validateReceivedPayloads;
    }

    public ProcessingDto setValidateReceivedPayloads(boolean validateReceivedPayloads) {
        this.validateReceivedPayloads = validateReceivedPayloads;
        return this;
    }

    public EncryptPayloadsDto getEncryptPayloads() {
        return this.encryptPayloads;
    }

    public ProcessingDto setEncryptPayloads(EncryptPayloadsDto encryptPayloads) {
        this.encryptPayloads = encryptPayloads;
        return this;
    }

    public ExpectEncryptedPayloadsDto getExpectEncryptedPayloads() {
        return this.expectEncryptedPayloads;
    }

    public ProcessingDto setExpectEncryptedPayloads(ExpectEncryptedPayloadsDto expectEncryptedPayloads) {
        this.expectEncryptedPayloads = expectEncryptedPayloads;
        return this;
    }

    public XmlModificationDto getModifySendingXmlPayloads() {
        return this.modifySendingXmlPayloads;
    }

    public ProcessingDto setModifySendingXmlPayloads(XmlModificationDto modifySendingXmlPayloads) {
        this.modifySendingXmlPayloads = modifySendingXmlPayloads;
        return this;
    }

    public XmlModificationDto getModifyReceivedXmlPayloads() {
        return this.modifyReceivedXmlPayloads;
    }

    public ProcessingDto setModifyReceivedXmlPayloads(XmlModificationDto modifyReceivedXmlPayloads) {
        this.modifyReceivedXmlPayloads = modifyReceivedXmlPayloads;
        return this;
    }

    public boolean isCreateEnergylinkXmlFormat() {
        return this.createEnergylinkXmlFormat;
    }

    public ProcessingDto setCreateEnergylinkXmlFormat(boolean createEnergylinkXmlFormat) {
        this.createEnergylinkXmlFormat = createEnergylinkXmlFormat;
        return this;
    }

    public boolean isProcessEnergylinkXmlFormat() {
        return this.processEnergylinkXmlFormat;
    }

    public ProcessingDto setProcessEnergylinkXmlFormat(boolean processEnergylinkXmlFormat) {
        this.processEnergylinkXmlFormat = processEnergylinkXmlFormat;
        return this;
    }

    public boolean isCustomValidationOnReceivedPayloads() {
        return this.customValidationOnReceivedPayloads;
    }

    public ProcessingDto setCustomValidationOnReceivedPayloads(boolean customValidationOnReceivedPayloads) {
        this.customValidationOnReceivedPayloads = customValidationOnReceivedPayloads;
        return this;
    }

    public boolean isCustomValidationOnTransmittedPayloads() {
        return this.customValidationOnTransmittedPayloads;
    }

    public ProcessingDto setCustomValidationOnTransmittedPayloads(boolean customValidationOnTransmittedPayloads) {
        this.customValidationOnTransmittedPayloads = customValidationOnTransmittedPayloads;
        return this;
    }
}

