/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.processing.data.EncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.processing.data.EncryptionFormat;
import de.ponton.xmlpipe.rest.cpa.validation.PartnerCertificate;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="These settings contain the parameter for encrypt payloads", name="Agreement.Processing.EncryptPayloads")
public class EncryptPayloadsDto {
    @NotNull
    @Schema(description="The encryption algorithm")
    private EncryptionAlgorithm contentEncryptionAlgorithm;
    @NotNull
    @Schema(description="Format of the encrypted data")
    private EncryptionFormat format;
    @PartnerCertificate(remote=true)
    @Schema(description="Identifier of the communication partner certificate used for encryption of the payload")
    @TrimmedField
    private String communicationPartnerCertificateId;

    public EncryptionAlgorithm getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public EncryptPayloadsDto setContentEncryptionAlgorithm(EncryptionAlgorithm contentEncryptionAlgorithm) {
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
        return this;
    }

    public EncryptionFormat getFormat() {
        return this.format;
    }

    public EncryptPayloadsDto setFormat(EncryptionFormat format) {
        this.format = format;
        return this;
    }

    public String getCommunicationPartnerCertificateId() {
        return this.communicationPartnerCertificateId;
    }

    public EncryptPayloadsDto setCommunicationPartnerCertificateId(String communicationPartnerCertificateId) {
        this.communicationPartnerCertificateId = communicationPartnerCertificateId;
        return this;
    }
}

