/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.validation;

import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.HashAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.SignatureEncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.validation.SignatureEncryptionAlgorithmConstraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;

@SupportedValidationTarget(value={ValidationTarget.ANNOTATED_ELEMENT})
public class SignatureEncryptionAlgorithmValidator
implements ConstraintValidator<SignatureEncryptionAlgorithmConstraint, Object> {
    private String type;

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        switch (this.type) {
            case "AS1": 
            case "AS2": 
            case "AS3": {
                return this.validate(value, de.ponton.xmlpipe.rest.cpa.packaging.as123.data.HashAlgorithm.class, de.ponton.xmlpipe.rest.cpa.packaging.as123.data.SignatureEncryptionAlgorithm.class);
            }
            case "AS4": {
                return this.validate(value, HashAlgorithm.class, SignatureEncryptionAlgorithm.class);
            }
        }
        return false;
    }

    private boolean validate(Object value, Class<?> hashAlgorithmClass, Class<?> signatureEncryptionAlgoClass) {
        Optional<Field> hashAlgorithm = Arrays.stream(value.getClass().getDeclaredFields()).filter(field -> field.getType().equals(hashAlgorithmClass)).peek(field -> field.setAccessible(true)).findFirst();
        Optional<Field> signatureEncryptionAlgo = Arrays.stream(value.getClass().getDeclaredFields()).filter(field -> field.getType().equals(signatureEncryptionAlgoClass)).peek(field -> field.setAccessible(true)).findFirst();
        if (hashAlgorithm.isPresent() && signatureEncryptionAlgo.isPresent()) {
            try {
                return signatureEncryptionAlgoClass.getDeclaredMethod("asOptionValue", hashAlgorithmClass, signatureEncryptionAlgoClass).invoke(null, hashAlgorithm.get().get(value), signatureEncryptionAlgo.get().get(value)) != null;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        }
        return false;
    }

    public void initialize(SignatureEncryptionAlgorithmConstraint constraintAnnotation) {
        this.type = constraintAnnotation.type();
    }
}

