/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.as4.data;

import java.util.HashMap;
import java.util.Map;

public enum SigningKeyInformation {
    ISSUER_AND_SERIAL_NUMBER("IssuerAndSerialNumber"),
    BINARY_SECURITY_TOKEN("BinarySecurityToken"),
    BINARY_SECURITY_TOKEN_PKIPATH("BinarySecurityTokenPkiPath"),
    SUBJECT_KEY_IDENTIFIER("SubjectKeyIdentifier");

    private String name;
    private static final Map<String, SigningKeyInformation> nameLookup;

    private SigningKeyInformation(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SigningKeyInformation of(String name) {
        return nameLookup.get(name);
    }

    static {
        nameLookup = new HashMap<String, SigningKeyInformation>();
        for (SigningKeyInformation keyInformation : SigningKeyInformation.values()) {
            nameLookup.put(keyInformation.getName(), keyInformation);
        }
    }
}

