/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.as123.data;

import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.SignatureEncryptionAlgorithm;

public enum HashAlgorithm {
    SHA1,
    SHA256,
    SHA384,
    SHA512;


    public static HashAlgorithm ofOptionValue(String optionValue) {
        switch (optionValue) {
            case "SHA-1 signed": 
            case "SHA-1/PSS signed": {
                return SHA1;
            }
            case "SHA-256/ECDSA signed": 
            case "SHA-256 signed": 
            case "SHA-256/PSS signed": {
                return SHA256;
            }
            case "SHA-384/ECDSA signed": 
            case "SHA-384 signed": 
            case "SHA-384/PSS signed": {
                return SHA384;
            }
            case "SHA-512 signed": 
            case "SHA-512/ECDSA signed": 
            case "SHA-512/PSS signed": {
                return SHA512;
            }
        }
        return null;
    }

    public static String asOptionValue(HashAlgorithm hashAlgorithm, SignatureEncryptionAlgorithm signatureEncryptionAlgorithm) {
        switch (signatureEncryptionAlgorithm) {
            case ECDSA: {
                switch (hashAlgorithm.ordinal()) {
                    case 1: {
                        return "SHA-256/ECDSA signed";
                    }
                    case 2: {
                        return "SHA-384/ECDSA signed";
                    }
                    case 3: {
                        return "SHA-512/ECDSA signed";
                    }
                }
                return null;
            }
            case RSA: {
                switch (hashAlgorithm.ordinal()) {
                    case 0: {
                        return "SHA-1 signed";
                    }
                    case 1: {
                        return "SHA-256 signed";
                    }
                    case 2: {
                        return "SHA-384 signed";
                    }
                    case 3: {
                        return "SHA-512 signed";
                    }
                }
                return null;
            }
            case RSASSA_PSS: {
                switch (hashAlgorithm.ordinal()) {
                    case 0: {
                        return "SHA-1/PSS signed";
                    }
                    case 1: {
                        return "SHA-256/PSS signed";
                    }
                    case 2: {
                        return "SHA-384/PSS signed";
                    }
                    case 3: {
                        return "SHA-512/PSS signed";
                    }
                }
                return null;
            }
        }
        return null;
    }
}

