/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.as123.data;

import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.KeyEncryptionAlgorithm;

public enum ContentEncryptionAlgorithm {
    AES128_CBC,
    AES128_GCM,
    AES192_CBC,
    AES192_GCM,
    AES256_CBC,
    AES256_GCM,
    DES_EDE3_CBC;


    public static ContentEncryptionAlgorithm ofOptionValueAS4(String optionValue) {
        return optionValue != null ? ContentEncryptionAlgorithm.ofOptionValue(optionValue.toUpperCase().replaceAll("-", "_")) : null;
    }

    public static ContentEncryptionAlgorithm ofOptionValue(String optionValue) {
        switch (optionValue) {
            case "AES128_CBC": 
            case "AES128_CBC/OAEP_SHA1": 
            case "AES128_CBC/OAEP_SHA256": 
            case "AES128_CBC/OAEP_SHA512": {
                return AES128_CBC;
            }
            case "AES128_GCM": 
            case "AES128_GCM/ECDH_SHA224": 
            case "AES128_GCM/ECDH_SHA256": 
            case "AES128_GCM/ECDH_SHA512": 
            case "AES128_GCM/OAEP_SHA256": 
            case "AES128_GCM/OAEP_SHA512": {
                return AES128_GCM;
            }
            case "AES192_CBC": 
            case "AES192_CBC/OAEP_SHA1": 
            case "AES192_CBC/OAEP_SHA256": 
            case "AES192_CBC/OAEP_SHA512": {
                return AES192_CBC;
            }
            case "AES192_GCM": 
            case "AES192_GCM/ECDH_SHA224": 
            case "AES192_GCM/ECDH_SHA256": 
            case "AES192_GCM/ECDH_SHA512": 
            case "AES192_GCM/OAEP_SHA256": 
            case "AES192_GCM/OAEP_SHA512": {
                return AES192_GCM;
            }
            case "AES256_CBC": 
            case "AES256_CBC/OAEP_SHA1": 
            case "AES256_CBC/OAEP_SHA256": 
            case "AES256_CBC/OAEP_SHA512": {
                return AES256_CBC;
            }
            case "AES256_GCM": 
            case "AES256_GCM/ECDH_SHA224": 
            case "AES256_GCM/ECDH_SHA256": 
            case "AES256_GCM/ECDH_SHA512": 
            case "AES256_GCM/OAEP_SHA256": 
            case "AES256_GCM/OAEP_SHA512": {
                return AES256_GCM;
            }
            case "DES_EDE3_CBC": 
            case "DES_EDE3_CBC/OAEP_SHA1": {
                return DES_EDE3_CBC;
            }
        }
        return null;
    }

    public static String asOptionValueAS4(ContentEncryptionAlgorithm contentEncryptionAlgorithm, KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        String value = ContentEncryptionAlgorithm.asOptionValue(contentEncryptionAlgorithm, keyEncryptionAlgorithm);
        return value != null ? value.toLowerCase().replaceAll("_", "-") : null;
    }

    public static String asOptionValue(ContentEncryptionAlgorithm contentEncryptionAlgorithm, KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        switch (contentEncryptionAlgorithm.ordinal()) {
            case 0: {
                switch (keyEncryptionAlgorithm) {
                    case RSA: {
                        return "AES128_CBC";
                    }
                    case RSAES_OAEP_SHA1: {
                        return "AES128_CBC/OAEP_SHA1";
                    }
                    case RSAES_OAEP_SHA256: {
                        return "AES128_CBC/OAEP_SHA256";
                    }
                    case RSAES_OAEP_SHA512: {
                        return "AES128_CBC/OAEP_SHA512";
                    }
                }
                return null;
            }
            case 1: {
                switch (keyEncryptionAlgorithm) {
                    case RSA: {
                        return "AES128_GCM";
                    }
                    case RSAES_OAEP_SHA256: {
                        return "AES128_GCM/OAEP_SHA256";
                    }
                    case RSAES_OAEP_SHA512: {
                        return "AES128_GCM/OAEP_SHA512";
                    }
                    case ECDH_SHA224: {
                        return "AES128_GCM/ECDH_SHA224";
                    }
                    case ECDH_SHA256: {
                        return "AES128_GCM/ECDH_SHA256";
                    }
                    case ECDH_SHA512: {
                        return "AES128_GCM/ECDH_SHA512";
                    }
                }
                return null;
            }
            case 2: {
                switch (keyEncryptionAlgorithm) {
                    case RSA: {
                        return "AES192_CBC";
                    }
                    case RSAES_OAEP_SHA1: {
                        return "AES192_CBC/OAEP_SHA1";
                    }
                    case RSAES_OAEP_SHA256: {
                        return "AES192_CBC/OAEP_SHA256";
                    }
                    case RSAES_OAEP_SHA512: {
                        return "AES192_CBC/OAEP_SHA512";
                    }
                }
                return null;
            }
            case 3: {
                switch (keyEncryptionAlgorithm) {
                    case RSA: {
                        return "AES192_GCM";
                    }
                    case RSAES_OAEP_SHA256: {
                        return "AES192_GCM/OAEP_SHA256";
                    }
                    case RSAES_OAEP_SHA512: {
                        return "AES192_GCM/OAEP_SHA512";
                    }
                    case ECDH_SHA224: {
                        return "AES192_GCM/ECDH_SHA224";
                    }
                    case ECDH_SHA256: {
                        return "AES192_GCM/ECDH_SHA256";
                    }
                    case ECDH_SHA512: {
                        return "AES192_GCM/ECDH_SHA512";
                    }
                }
                return null;
            }
            case 4: {
                switch (keyEncryptionAlgorithm) {
                    case RSA: {
                        return "AES256_CBC";
                    }
                    case RSAES_OAEP_SHA1: {
                        return "AES256_CBC/OAEP_SHA1";
                    }
                    case RSAES_OAEP_SHA256: {
                        return "AES256_CBC/OAEP_SHA256";
                    }
                    case RSAES_OAEP_SHA512: {
                        return "AES256_CBC/OAEP_SHA512";
                    }
                }
                return null;
            }
            case 5: {
                switch (keyEncryptionAlgorithm) {
                    case RSA: {
                        return "AES256_GCM";
                    }
                    case RSAES_OAEP_SHA256: {
                        return "AES256_GCM/OAEP_SHA256";
                    }
                    case RSAES_OAEP_SHA512: {
                        return "AES256_GCM/OAEP_SHA512";
                    }
                    case ECDH_SHA224: {
                        return "AES256_GCM/ECDH_SHA224";
                    }
                    case ECDH_SHA256: {
                        return "AES256_GCM/ECDH_SHA256";
                    }
                    case ECDH_SHA512: {
                        return "AES256_GCM/ECDH_SHA512";
                    }
                }
                return null;
            }
            case 6: {
                switch (keyEncryptionAlgorithm) {
                    case RSA: {
                        return "DES_EDE3_CBC";
                    }
                    case RSAES_OAEP_SHA1: {
                        return "DES_EDE3_CBC/OAEP_SHA1";
                    }
                }
                return null;
            }
        }
        return null;
    }
}

