/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PipelineIdNotFoundException;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class PipelineUtility {
    public Optional<String> getPipelineOptionValue(Communication communication, String path) {
        try {
            return Optional.ofNullable(communication.getPipelineOptionValue(path));
        }
        catch (OptionNotFoundException e) {
            return Optional.empty();
        }
    }

    public void removePipelineOptionValue(Communication communication, String path) {
        this.setPipelineOptionValue(communication, path, (String)null, null);
    }

    public void setPipelineOptionValue(Communication communication, String path, boolean value, String type) {
        this.setPipelineOptionValue(communication, path, Boolean.valueOf(value).toString(), type);
    }

    public void setPipelineOptionValue(Communication communication, String path, String value, String type) {
        try {
            if (value != null) {
                communication.setPipelineOptionValue(path, value, type);
            } else {
                communication.deletePipelineOption(path);
            }
        }
        catch (OptionNotFoundException | PipelineIdNotFoundException idNotFoundException) {
            // empty catch block
        }
    }

    public void setPipelineOptionValue(Communication communication, String path, Supplier<String> value, String type) {
        this.setPipelineOptionValue(communication, path, value.get(), type);
    }
}

