/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpa.CommunicationsTuple;
import de.ponton.xmlpipe.rest.cpa.packaging.EbXml20PackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingDtoHolder;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingUtility;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ServiceDto;
import de.ponton.xmlpipe.rest.cpa.packaging.ebxml.data.RequestAcknowledgements;
import de.ponton.xmlpipe.rest.cpa.packaging.ebxml.data.XmlSignatureEnabled;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import org.springframework.stereotype.Component;

@Component
public class EbXml20PackagingDtoFactory
implements IDtoFactory<PackagingDtoHolder<EbXml20PackagingDto>, CommunicationsTuple> {
    private final PackagingUtility packagingUtility;

    public EbXml20PackagingDtoFactory(PackagingUtility packagingUtility) {
        this.packagingUtility = packagingUtility;
    }

    @Override
    public PackagingDtoHolder<EbXml20PackagingDto> create(CommunicationsTuple valueObject) {
        EbXml20PackagingDto ebXml20PackagingDto = new EbXml20PackagingDto();
        Communication outbound = valueObject.getOutbound();
        XmlSignatureEnabled xmlSignatureEnabled = new XmlSignatureEnabled();
        this.packagingUtility.getPackagingOptionValue(outbound, "/XmlSignature").ifPresent(value -> ebXml20PackagingDto.setXmlSignatureEnabled(xmlSignatureEnabled));
        this.packagingUtility.getPackagingOptionValue(outbound, "/XmlSignature/certificateAlias").ifPresent(xmlSignatureEnabled::setOwnPartnerCertificateId);
        RequestAcknowledgements requestAcknowledgements = new RequestAcknowledgements();
        this.packagingUtility.getPackagingOptionValue(outbound, "/RequestAck").ifPresent(value -> {
            ebXml20PackagingDto.setRequestAcknowledgements(requestAcknowledgements);
            requestAcknowledgements.setRequestSignedAcknowledgements(value.equals("signed"));
        });
        ServiceDto service = new ServiceDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/Service").ifPresent(value -> {
            service.setValue((String)value);
            ebXml20PackagingDto.setService(service);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/Service/Type").ifPresent(service::setType);
        this.packagingUtility.getPackagingOptionValue(outbound, "/Action").ifPresent(ebXml20PackagingDto::setAction);
        this.packagingUtility.getPackagingOptionValue(outbound, "/DuplicateElimination").ifPresent(ebXml20PackagingDto::setRequestDuplicateElimination);
        this.packagingUtility.getPackagingOptionValue(outbound, "/SyncReply").ifPresent(ebXml20PackagingDto::setRequestSynchronousReply);
        this.packagingUtility.getPackagingOptionValue(outbound, "/CpaId").ifPresent(ebXml20PackagingDto::setCpaId);
        this.packagingUtility.getPackagingOptionValue(outbound, "/RoleFrom").ifPresent(ebXml20PackagingDto::setRoleFrom);
        this.packagingUtility.getPackagingOptionValue(outbound, "/RoleTo").ifPresent(ebXml20PackagingDto::setRoleTo);
        this.packagingUtility.getPackagingOptionValue(outbound, "/AttachmentRolePayload").ifPresent(ebXml20PackagingDto::setAttachmentRoleForPayload);
        this.packagingUtility.getPackagingOptionValue(outbound, "/AttachmentRoleSignature").ifPresent(ebXml20PackagingDto::setAttachmentRoleForSignature);
        this.packagingUtility.getPackagingOptionValue(outbound, "/AttachmentRoleOther").ifPresent(ebXml20PackagingDto::setAttachmentRoleForOther);
        Communication inbound = valueObject.getInbound();
        this.packagingUtility.getPackagingOptionValue(inbound, "/XmlSignature").ifPresent(ebXml20PackagingDto::setExpectXmlSignature);
        this.packagingUtility.getPackagingOptionValue(inbound, "/AttachmentRolePayload").ifPresent(ebXml20PackagingDto::setExpectedAttachmentRoleForPayload);
        this.packagingUtility.getPackagingOptionValue(inbound, "/AttachmentRoleSignature").ifPresent(ebXml20PackagingDto::setExpectedAttachmentRoleForSignature);
        this.packagingUtility.getPackagingOptionValue(inbound, "/AttachmentRoleOther").ifPresent(ebXml20PackagingDto::setExpectedAttachmentRoleForOther);
        return new PackagingDtoHolder<EbXml20PackagingDto>(ebXml20PackagingDto, valueObject);
    }

    @Override
    public CommunicationsTuple parse(PackagingDtoHolder<EbXml20PackagingDto> valueObject) {
        EbXml20PackagingDto ebXml20PackagingDto = valueObject.getPackagingDto();
        Communication outbound = valueObject.getCommunicationsTuple().getOutbound();
        if (ebXml20PackagingDto.getXmlSignatureEnabled() != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/XmlSignature", String.valueOf(true), "boolean");
            this.packagingUtility.setPackagingOptionValue(outbound, "/XmlSignature/certificateAlias", ebXml20PackagingDto.getXmlSignatureEnabled().getOwnPartnerCertificateId(), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/XmlSignature");
        }
        if (ebXml20PackagingDto.getRequestAcknowledgements() != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/RequestAck", ebXml20PackagingDto.getRequestAcknowledgements().isRequestSignedAcknowledgements() ? "signed" : "unsigned", "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/RequestAck");
        }
        if (ebXml20PackagingDto.getService() != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/Service", ebXml20PackagingDto.getService().getValue(), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/Service/Type", ebXml20PackagingDto.getService().getType(), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/Service");
        }
        this.packagingUtility.setPackagingOptionValue(outbound, "/Action", ebXml20PackagingDto.getAction(), "string");
        this.packagingUtility.setPackagingOptionValue(outbound, "/DuplicateElimination", String.valueOf(ebXml20PackagingDto.isRequestDuplicateElimination()), "boolean");
        this.packagingUtility.setPackagingOptionValue(outbound, "/SyncReply", String.valueOf(ebXml20PackagingDto.isRequestSynchronousReply()), "boolean");
        this.packagingUtility.setPackagingOptionValue(outbound, "/CpaId", ebXml20PackagingDto.getCpaId(), "string");
        this.packagingUtility.setPackagingOptionValue(outbound, "/RoleFrom", ebXml20PackagingDto.getRoleFrom(), "string");
        this.packagingUtility.setPackagingOptionValue(outbound, "/RoleTo", ebXml20PackagingDto.getRoleTo(), "string");
        this.packagingUtility.setPackagingOptionValue(outbound, "/AttachmentRolePayload", ebXml20PackagingDto.getAttachmentRoleForPayload(), "string");
        this.packagingUtility.setPackagingOptionValue(outbound, "/AttachmentRoleSignature", ebXml20PackagingDto.getAttachmentRoleForSignature(), "string");
        this.packagingUtility.setPackagingOptionValue(outbound, "/AttachmentRoleOther", ebXml20PackagingDto.getAttachmentRoleForOther(), "string");
        Communication inbound = valueObject.getCommunicationsTuple().getInbound();
        this.packagingUtility.setPackagingOptionValue(inbound, "/XmlSignature", String.valueOf(ebXml20PackagingDto.isExpectXmlSignature()), "boolean");
        this.packagingUtility.setPackagingOptionValue(inbound, "/AttachmentRolePayload", ebXml20PackagingDto.getExpectedAttachmentRoleForPayload(), "string");
        this.packagingUtility.setPackagingOptionValue(inbound, "/AttachmentRoleSignature", ebXml20PackagingDto.getExpectedAttachmentRoleForSignature(), "string");
        this.packagingUtility.setPackagingOptionValue(inbound, "/AttachmentRoleOther", ebXml20PackagingDto.getExpectedAttachmentRoleForOther(), "string");
        return valueObject.getCommunicationsTuple();
    }
}

