/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.packaging.IPackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ServiceDto;
import de.ponton.xmlpipe.rest.cpa.packaging.ebxml.data.RequestAcknowledgements;
import de.ponton.xmlpipe.rest.cpa.packaging.ebxml.data.XmlSignatureEnabled;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.NullOrNotBlank;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="EbXML 2.0 Packaging options", name="Agreement.EbXML")
public class EbXml20PackagingDto
implements IPackagingDto {
    @NotBlank
    private final String type = "EbXml20";
    @Valid
    @Schema(description="When this structure exists, then all send messages will be signed.")
    private XmlSignatureEnabled xmlSignatureEnabled;
    @Valid
    @Schema(description="When this structure exists, then it is expected that the receiver will send acknowledgements for all received messages.")
    private RequestAcknowledgements requestAcknowledgements;
    @Valid
    @NotNull
    private ServiceDto service;
    @NotBlank
    @TrimmedField
    private String action;
    private boolean requestDuplicateElimination;
    private boolean requestSynchronousReply;
    @NotBlank
    @Schema(description="This is an identifier for the agreed communication settings between sender and receiver. The PONTON X/P Messenger does not process this value.")
    @TrimmedField
    private String cpaId;
    @Schema(description="This value can be used to define a business related role for the sender. The PONTON X/P Messenger does not process this value.")
    @NullOrNotBlank
    @TrimmedField
    private String roleFrom;
    @Schema(description="This value can be used to define a business related role for the receiver. The PONTON X/P Messenger does not process this value.")
    @NullOrNotBlank
    @TrimmedField
    private String roleTo;
    @Schema(description="This value is used to define the payload attachment, if there are multiple attachments included in the message.")
    @NullOrNotBlank
    @TrimmedField
    private String attachmentRoleForPayload;
    @Schema(description="This value is used to define the signature attachment, if there are multiple attachments included in the message.")
    @NullOrNotBlank
    @TrimmedField
    private String attachmentRoleForSignature;
    @Schema(description="This value is used to define any other attachment, if there are multiple attachments included in the message.")
    @NullOrNotBlank
    @TrimmedField
    private String attachmentRoleForOther;
    @Schema(description="received messages are expected to have an XML signature if this is enabled.")
    private boolean expectXmlSignature;
    @Schema(description="This value is used to identify the payload attachment, if there are multiple attachments included in the message.")
    @NullOrNotBlank
    @TrimmedField
    private String expectedAttachmentRoleForPayload;
    @Schema(description="This value is used to identify the signature attachment, if there are multiple attachments included in the message.")
    @NullOrNotBlank
    @TrimmedField
    private String expectedAttachmentRoleForSignature;
    @Schema(description="This value is used to identify any other attachment, if there are multiple attachments included in the message.")
    @NullOrNotBlank
    @TrimmedField
    private String expectedAttachmentRoleForOther;

    public XmlSignatureEnabled getXmlSignatureEnabled() {
        return this.xmlSignatureEnabled;
    }

    public EbXml20PackagingDto setXmlSignatureEnabled(XmlSignatureEnabled xmlSignatureEnabled) {
        this.xmlSignatureEnabled = xmlSignatureEnabled;
        return this;
    }

    public RequestAcknowledgements getRequestAcknowledgements() {
        return this.requestAcknowledgements;
    }

    public EbXml20PackagingDto setRequestAcknowledgements(RequestAcknowledgements requestAcknowledgements) {
        this.requestAcknowledgements = requestAcknowledgements;
        return this;
    }

    public ServiceDto getService() {
        return this.service;
    }

    public EbXml20PackagingDto setService(ServiceDto service) {
        this.service = service;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public EbXml20PackagingDto setAction(String action) {
        this.action = action;
        return this;
    }

    public boolean isRequestDuplicateElimination() {
        return this.requestDuplicateElimination;
    }

    public EbXml20PackagingDto setRequestDuplicateElimination(boolean requestDuplicateElimination) {
        this.requestDuplicateElimination = requestDuplicateElimination;
        return this;
    }

    public void setRequestDuplicateElimination(String value) {
        this.setRequestDuplicateElimination(Boolean.parseBoolean(value));
    }

    public boolean isRequestSynchronousReply() {
        return this.requestSynchronousReply;
    }

    public EbXml20PackagingDto setRequestSynchronousReply(boolean requestSynchronousReply) {
        this.requestSynchronousReply = requestSynchronousReply;
        return this;
    }

    public void setRequestSynchronousReply(String value) {
        this.setRequestSynchronousReply(Boolean.parseBoolean(value));
    }

    public String getCpaId() {
        return this.cpaId;
    }

    public EbXml20PackagingDto setCpaId(String cpaId) {
        this.cpaId = cpaId;
        return this;
    }

    public String getRoleFrom() {
        return this.roleFrom;
    }

    public EbXml20PackagingDto setRoleFrom(String roleFrom) {
        this.roleFrom = roleFrom;
        return this;
    }

    public String getRoleTo() {
        return this.roleTo;
    }

    public EbXml20PackagingDto setRoleTo(String roleTo) {
        this.roleTo = roleTo;
        return this;
    }

    public String getAttachmentRoleForPayload() {
        return this.attachmentRoleForPayload;
    }

    public EbXml20PackagingDto setAttachmentRoleForPayload(String attachmentRoleForPayload) {
        this.attachmentRoleForPayload = attachmentRoleForPayload;
        return this;
    }

    public String getAttachmentRoleForSignature() {
        return this.attachmentRoleForSignature;
    }

    public EbXml20PackagingDto setAttachmentRoleForSignature(String attachmentRoleForSignature) {
        this.attachmentRoleForSignature = attachmentRoleForSignature;
        return this;
    }

    public String getAttachmentRoleForOther() {
        return this.attachmentRoleForOther;
    }

    public EbXml20PackagingDto setAttachmentRoleForOther(String attachmentRoleForOther) {
        this.attachmentRoleForOther = attachmentRoleForOther;
        return this;
    }

    public boolean isExpectXmlSignature() {
        return this.expectXmlSignature;
    }

    public EbXml20PackagingDto setExpectXmlSignature(boolean expectXmlSignature) {
        this.expectXmlSignature = expectXmlSignature;
        return this;
    }

    public void setExpectXmlSignature(String value) {
        this.setExpectXmlSignature(Boolean.parseBoolean(value));
    }

    public String getExpectedAttachmentRoleForPayload() {
        return this.expectedAttachmentRoleForPayload;
    }

    public EbXml20PackagingDto setExpectedAttachmentRoleForPayload(String expectedAttachmentRoleForPayload) {
        this.expectedAttachmentRoleForPayload = expectedAttachmentRoleForPayload;
        return this;
    }

    public String getExpectedAttachmentRoleForSignature() {
        return this.expectedAttachmentRoleForSignature;
    }

    public EbXml20PackagingDto setExpectedAttachmentRoleForSignature(String expectedAttachmentRoleForSignature) {
        this.expectedAttachmentRoleForSignature = expectedAttachmentRoleForSignature;
        return this;
    }

    public String getExpectedAttachmentRoleForOther() {
        return this.expectedAttachmentRoleForOther;
    }

    public EbXml20PackagingDto setExpectedAttachmentRoleForOther(String expectedAttachmentRoleForOther) {
        this.expectedAttachmentRoleForOther = expectedAttachmentRoleForOther;
        return this;
    }

    @Override
    public String getType() {
        return "EbXml20";
    }
}

