/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpa.CommunicationsTuple;
import de.ponton.xmlpipe.rest.cpa.packaging.AS3PackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingDtoHolder;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingUtility;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.EncryptMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.ExpectEncryptedMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.ExpectSignedAcknowledgementsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.ExpectSignedMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.RequestAcknowledgementsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.SignAcknowledgementsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.SignMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.ContentEncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.HashAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.KeyEncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.MICAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.SignatureEncryptionAlgorithm;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import org.springframework.stereotype.Component;

@Component
public class AS3PackagingDtoFactory
implements IDtoFactory<PackagingDtoHolder<AS3PackagingDto>, CommunicationsTuple> {
    private final PackagingUtility packagingUtility;

    public AS3PackagingDtoFactory(PackagingUtility packagingUtility) {
        this.packagingUtility = packagingUtility;
    }

    @Override
    public PackagingDtoHolder<AS3PackagingDto> create(CommunicationsTuple communicationsTuple) {
        AS3PackagingDto packagingDto = new AS3PackagingDto();
        PackagingDtoHolder<AS3PackagingDto> packagingDtoHolder = new PackagingDtoHolder<AS3PackagingDto>(packagingDto, communicationsTuple);
        Communication inbound = communicationsTuple.getInbound();
        Communication outbound = communicationsTuple.getOutbound();
        RequestAcknowledgementsDto requestAcknowledgementsDto = new RequestAcknowledgementsDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/RequestMDN").ifPresent(value -> {
            MICAlgorithm micAlgorithm = MICAlgorithm.ofOptionValue(value);
            if (micAlgorithm != null) {
                requestAcknowledgementsDto.setRequestSignedAcknowledgements(true);
                requestAcknowledgementsDto.setMicAlgorithm(micAlgorithm);
            }
            packagingDto.setRequestAcknowledgements(requestAcknowledgementsDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/ReplyURL").ifPresent(requestAcknowledgementsDto::setAsynchronousReplyURL);
        SignMessagesDto signMessagesDto = new SignMessagesDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/SignMessage").ifPresent(value -> {
            signMessagesDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value));
            signMessagesDto.setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.ofOptionValue(value));
            packagingDto.setSignMessages(signMessagesDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/SignMessage/certificateAlias").ifPresent(signMessagesDto::setOwnPartnerCertificateId);
        ExpectSignedMessagesDto expectSignedMessagesDto = new ExpectSignedMessagesDto();
        this.packagingUtility.getPackagingOptionValue(inbound, "/SignMessage").ifPresent(value -> {
            expectSignedMessagesDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value));
            expectSignedMessagesDto.setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.ofOptionValue(value));
            packagingDto.setExpectSignedMessages(expectSignedMessagesDto);
        });
        SignAcknowledgementsDto signAcknowledgementsDto = new SignAcknowledgementsDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/SmimeMdnSignature").ifPresent(value -> {
            if ("Same as business signature".equals(value) && packagingDto.getSignMessages() != null) {
                signAcknowledgementsDto.setHashAlgorithm(packagingDto.getSignMessages().getHashAlgorithm());
                signAcknowledgementsDto.setSignatureEncryptionAlgorithm(packagingDto.getSignMessages().getSignatureEncryptionAlgorithm());
            } else {
                signAcknowledgementsDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value));
                signAcknowledgementsDto.setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.ofOptionValue(value));
            }
            packagingDto.setSignAcknowledgements(signAcknowledgementsDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/SmimeMdnSignature/certificateAlias").ifPresent(value -> {
            if ("Same as business signature".equals(value) && packagingDto.getSignMessages() != null) {
                signAcknowledgementsDto.setOwnPartnerCertificateId(packagingDto.getSignAcknowledgements().getOwnPartnerCertificateId());
            } else {
                signAcknowledgementsDto.setOwnPartnerCertificateId((String)value);
            }
        });
        ExpectSignedAcknowledgementsDto expectSignedAcknowledgementsDto = new ExpectSignedAcknowledgementsDto();
        this.packagingUtility.getPackagingOptionValue(inbound, "/SmimeMdnSignature").ifPresent(value -> {
            if ("Same as business signature".equals(value) && packagingDto.getExpectSignedMessages() != null) {
                expectSignedAcknowledgementsDto.setHashAlgorithm(packagingDto.getExpectSignedMessages().getHashAlgorithm());
                expectSignedAcknowledgementsDto.setSignatureEncryptionAlgorithm(packagingDto.getExpectSignedMessages().getSignatureEncryptionAlgorithm());
            } else {
                expectSignedAcknowledgementsDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value));
                expectSignedAcknowledgementsDto.setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.ofOptionValue(value));
            }
            packagingDto.setExpectSignedAcknowledgements(expectSignedAcknowledgementsDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/CompressMessage").ifPresent(value -> packagingDto.setCompressMessages(Boolean.parseBoolean(value)));
        this.packagingUtility.getPackagingOptionValue(inbound, "/CompressMessage").ifPresent(value -> packagingDto.setExpectCompressedMessages(Boolean.parseBoolean(value)));
        EncryptMessagesDto encryptMessagesDto = new EncryptMessagesDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/EncryptMessage").ifPresent(value -> {
            this.packagingUtility.getPackagingOptionValue(outbound, "/EncryptMessage/ExtendedEncryptionAlgorithm").ifPresent(algo -> {
                encryptMessagesDto.setContentEncryptionAlgorithm(ContentEncryptionAlgorithm.ofOptionValue(algo));
                encryptMessagesDto.setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm.ofOptionValue(algo));
            });
            packagingDto.setEncryptMessages(encryptMessagesDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/EncryptMessage/certificateAlias").ifPresent(encryptMessagesDto::setCommunicationPartnerCertificateId);
        ExpectEncryptedMessagesDto expectEncryptedMessagesDto = new ExpectEncryptedMessagesDto();
        this.packagingUtility.getPackagingOptionValue(inbound, "/EncryptMessage").ifPresent(value -> {
            this.packagingUtility.getPackagingOptionValue(inbound, "/EncryptMessage/ExtendedEncryptionAlgorithm").ifPresent(algo -> {
                expectEncryptedMessagesDto.setContentEncryptionAlgorithm(ContentEncryptionAlgorithm.ofOptionValue(algo));
                expectEncryptedMessagesDto.setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm.ofOptionValue(algo));
            });
            packagingDto.setExpectEncryptedMessages(expectEncryptedMessagesDto);
        });
        this.packagingUtility.getPackagingOptionValue(inbound, "/DuplicateElimination").ifPresent(value -> packagingDto.setIgnoreDuplicateMessages(Boolean.parseBoolean(value)));
        return packagingDtoHolder;
    }

    @Override
    public CommunicationsTuple parse(PackagingDtoHolder<AS3PackagingDto> packagingDtoHolder) {
        SignMessagesDto signMessagesDto;
        AS3PackagingDto packagingDto = packagingDtoHolder.getPackagingDto();
        Communication inbound = packagingDtoHolder.getCommunicationsTuple().getInbound();
        Communication outbound = packagingDtoHolder.getCommunicationsTuple().getOutbound();
        this.packagingUtility.setPackagingOptionValue(outbound, "/RequestMDN", () -> {
            RequestAcknowledgementsDto requestAcknowledgementsDto = packagingDto.getRequestAcknowledgements();
            if (requestAcknowledgementsDto != null) {
                if (requestAcknowledgementsDto.isRequestSignedAcknowledgements()) {
                    return MICAlgorithm.asOptionValue(requestAcknowledgementsDto.getMicAlgorithm());
                }
                return "unsigned";
            }
            return null;
        }, "string");
        if (packagingDto.getRequestAcknowledgements() != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/ReplyURL", packagingDto.getRequestAcknowledgements().getAsynchronousReplyURL(), "string");
        }
        if ((signMessagesDto = packagingDto.getSignMessages()) != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/SignMessage", () -> SignatureEncryptionAlgorithm.asOptionValue(signMessagesDto.getHashAlgorithm(), signMessagesDto.getSignatureEncryptionAlgorithm()), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/SignMessage/certificateAlias", signMessagesDto.getOwnPartnerCertificateId(), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/SignMessage");
        }
        ExpectSignedMessagesDto expectSignedMessagesDto = packagingDto.getExpectSignedMessages();
        if (expectSignedMessagesDto != null) {
            this.packagingUtility.setPackagingOptionValue(inbound, "/SignMessage", () -> SignatureEncryptionAlgorithm.asOptionValue(expectSignedMessagesDto.getHashAlgorithm(), expectSignedMessagesDto.getSignatureEncryptionAlgorithm()), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(inbound, "/SignMessage");
        }
        SignAcknowledgementsDto signAcknowledgementsDto = packagingDto.getSignAcknowledgements();
        if (signAcknowledgementsDto != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/SmimeMdnSignature", () -> SignatureEncryptionAlgorithm.asOptionValue(signAcknowledgementsDto.getHashAlgorithm(), signAcknowledgementsDto.getSignatureEncryptionAlgorithm()), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/SmimeMdnSignature/certificateAlias", signAcknowledgementsDto.getOwnPartnerCertificateId(), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/SmimeMdnSignature");
        }
        ExpectSignedAcknowledgementsDto expectSignedAcknowledgementsDto = packagingDto.getExpectSignedAcknowledgements();
        if (expectSignedAcknowledgementsDto != null) {
            this.packagingUtility.setPackagingOptionValue(inbound, "/SmimeMdnSignature", () -> SignatureEncryptionAlgorithm.asOptionValue(expectSignedAcknowledgementsDto.getHashAlgorithm(), expectSignedAcknowledgementsDto.getSignatureEncryptionAlgorithm()), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(inbound, "/SmimeMdnSignature");
        }
        this.packagingUtility.setPackagingOptionValue(outbound, "/CompressMessage", packagingDto.isCompressMessages(), "boolean");
        this.packagingUtility.setPackagingOptionValue(inbound, "/CompressMessage", packagingDto.isExpectCompressedMessages(), "boolean");
        EncryptMessagesDto encryptMessagesDto = packagingDto.getEncryptMessages();
        if (encryptMessagesDto != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/EncryptMessage", Boolean.TRUE.toString(), "boolean");
            this.packagingUtility.setPackagingOptionValue(outbound, "/EncryptMessage/ExtendedEncryptionAlgorithm", () -> ContentEncryptionAlgorithm.asOptionValue(encryptMessagesDto.getContentEncryptionAlgorithm(), encryptMessagesDto.getKeyEncryptionAlgorithm()), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/EncryptMessage/certificateAlias", encryptMessagesDto.getCommunicationPartnerCertificateId(), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/EncryptMessage");
        }
        ExpectEncryptedMessagesDto expectEncryptedMessagesDto = packagingDto.getExpectEncryptedMessages();
        if (expectEncryptedMessagesDto != null) {
            this.packagingUtility.setPackagingOptionValue(inbound, "/EncryptMessage", Boolean.TRUE.toString(), "boolean");
            this.packagingUtility.setPackagingOptionValue(inbound, "/EncryptMessage/ExtendedEncryptionAlgorithm", () -> ContentEncryptionAlgorithm.asOptionValue(expectEncryptedMessagesDto.getContentEncryptionAlgorithm(), expectEncryptedMessagesDto.getKeyEncryptionAlgorithm()), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(inbound, "/EncryptMessage");
        }
        this.packagingUtility.setPackagingOptionValue(inbound, "/DuplicateElimination", packagingDto.isIgnoreDuplicateMessages(), "boolean");
        return packagingDtoHolder.getCommunicationsTuple();
    }
}

