/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.packaging.IPackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.EncryptMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.ExpectEncryptedMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.ExpectSignedAcknowledgementsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.ExpectSignedMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.MailClientFormatDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.RequestAcknowledgementsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.SignAcknowledgementsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.SignMessagesDto;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="AS1 packaging options", name="Agreement.AS1")
public class AS1PackagingDto
implements IPackagingDto {
    @NotBlank
    private final String type = "AS1";
    private boolean simulateAcknowledgements;
    @Valid
    @Schema(description="For reliable messaging it is highly recommended to activate the request acknowledgements. This will force ALL outbound messages to this partner to require MDNs. ")
    private RequestAcknowledgementsDto requestAcknowledgements;
    @Valid
    @Schema(description="When this structure exists, then all MDNs will be signed.")
    private SignAcknowledgementsDto signAcknowledgements;
    @Valid
    @Schema(description="When this structure exists, then all received MDNs are expected to be signed.")
    private ExpectSignedAcknowledgementsDto expectSignedAcknowledgements;
    @Valid
    @Schema(description="When this structure exists, then all send messages will be signed.")
    private SignMessagesDto signMessages;
    @Valid
    @Schema(description="When this structure exists, then all received messages are expected to be signed.")
    private ExpectSignedMessagesDto expectSignedMessages;
    @Schema(description="all transmitted messages will be compressed when this flag is enabled.")
    private boolean compressMessages;
    @Schema(description="all received messages are expected to be compressed when this flag is enabled.")
    private boolean expectCompressedMessages;
    @Valid
    @Schema(description="When this structure exists, then all send messages will be encrypted.")
    private EncryptMessagesDto encryptMessages;
    @Valid
    @Schema(description="When this structure exists, then all received messages are expected to be encrypted.")
    private ExpectEncryptedMessagesDto expectEncryptedMessages;
    @Schema(description="received email messages are accepted even if they are not strictly AS1 conformant. This allows to receive emails sent by a regular email client.")
    private boolean acceptMailClientFormat;
    @Schema(description="this is a static text that will be used as email subject when sending our AS1 messages.")
    @TrimmedField
    private String mailSubject;
    @Valid
    @Schema(description="When this structure exists, all transmitted messages will use a mail structure that can be processed by email clients. This will result in emails that are not strictly AS1 conformant.")
    private MailClientFormatDto sendMessagesInMailClientFormat;
    @Schema(description="when this flag is enabled, then all received mails with the same message id are ignored.")
    private boolean ignoreDuplicateMessages;

    @Override
    public String getType() {
        return "AS1";
    }

    public boolean isSimulateAcknowledgements() {
        return this.simulateAcknowledgements;
    }

    public void setSimulateAcknowledgements(boolean simulateAcknowledgements) {
        this.simulateAcknowledgements = simulateAcknowledgements;
    }

    public RequestAcknowledgementsDto getRequestAcknowledgements() {
        return this.requestAcknowledgements;
    }

    public AS1PackagingDto setRequestAcknowledgements(RequestAcknowledgementsDto requestAcknowledgements) {
        this.requestAcknowledgements = requestAcknowledgements;
        return this;
    }

    public SignAcknowledgementsDto getSignAcknowledgements() {
        return this.signAcknowledgements;
    }

    public AS1PackagingDto setSignAcknowledgements(SignAcknowledgementsDto signAcknowledgements) {
        this.signAcknowledgements = signAcknowledgements;
        return this;
    }

    public ExpectSignedAcknowledgementsDto getExpectSignedAcknowledgements() {
        return this.expectSignedAcknowledgements;
    }

    public AS1PackagingDto setExpectSignedAcknowledgements(ExpectSignedAcknowledgementsDto expectSignedAcknowledgements) {
        this.expectSignedAcknowledgements = expectSignedAcknowledgements;
        return this;
    }

    public SignMessagesDto getSignMessages() {
        return this.signMessages;
    }

    public AS1PackagingDto setSignMessages(SignMessagesDto signMessages) {
        this.signMessages = signMessages;
        return this;
    }

    public ExpectSignedMessagesDto getExpectSignedMessages() {
        return this.expectSignedMessages;
    }

    public AS1PackagingDto setExpectSignedMessages(ExpectSignedMessagesDto expectSignedMessages) {
        this.expectSignedMessages = expectSignedMessages;
        return this;
    }

    public boolean isCompressMessages() {
        return this.compressMessages;
    }

    public AS1PackagingDto setCompressMessages(boolean compressMessages) {
        this.compressMessages = compressMessages;
        return this;
    }

    public boolean isExpectCompressedMessages() {
        return this.expectCompressedMessages;
    }

    public AS1PackagingDto setExpectCompressedMessages(boolean expectCompressedMessages) {
        this.expectCompressedMessages = expectCompressedMessages;
        return this;
    }

    public EncryptMessagesDto getEncryptMessages() {
        return this.encryptMessages;
    }

    public AS1PackagingDto setEncryptMessages(EncryptMessagesDto encryptMessages) {
        this.encryptMessages = encryptMessages;
        return this;
    }

    public ExpectEncryptedMessagesDto getExpectEncryptedMessages() {
        return this.expectEncryptedMessages;
    }

    public AS1PackagingDto setExpectEncryptedMessages(ExpectEncryptedMessagesDto expectEncryptedMessages) {
        this.expectEncryptedMessages = expectEncryptedMessages;
        return this;
    }

    public boolean isAcceptMailClientFormat() {
        return this.acceptMailClientFormat;
    }

    public AS1PackagingDto setAcceptMailClientFormat(boolean acceptMailClientFormat) {
        this.acceptMailClientFormat = acceptMailClientFormat;
        return this;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public AS1PackagingDto setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
        return this;
    }

    public MailClientFormatDto getSendMessagesInMailClientFormat() {
        return this.sendMessagesInMailClientFormat;
    }

    public AS1PackagingDto setSendMessagesInMailClientFormat(MailClientFormatDto sendMessagesInMailClientFormat) {
        this.sendMessagesInMailClientFormat = sendMessagesInMailClientFormat;
        return this;
    }

    public boolean isIgnoreDuplicateMessages() {
        return this.ignoreDuplicateMessages;
    }

    public AS1PackagingDto setIgnoreDuplicateMessages(boolean ignoreDuplicateMessages) {
        this.ignoreDuplicateMessages = ignoreDuplicateMessages;
        return this;
    }
}

