/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.communication;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpa.communication.CommunicationDto;
import de.ponton.xmlpipe.rest.cpa.communication.CommunicationDtoHolder;
import de.ponton.xmlpipe.rest.cpa.rules.CommunicationRuleDataDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.cp.Authentication;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.RuleData;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.stereotype.Component;

@Component
public class CommunicationDtoFactory
implements IDtoFactory<CommunicationDtoHolder, Agreement> {
    private final CommunicationRuleDataDtoFactory ruleDataDtoFactory;

    public CommunicationDtoFactory(CommunicationRuleDataDtoFactory ruleDataDtoFactory) {
        this.ruleDataDtoFactory = ruleDataDtoFactory;
    }

    @Override
    public CommunicationDtoHolder create(Agreement agreement) {
        CommunicationDto communicationDto = new CommunicationDto();
        try {
            Communication outbound = agreement.getCommunication(agreement.getPartner1LocalId(), agreement.getPartner2LocalId());
            communicationDto.setPingAllEnabled(agreement.isPingAllEnabled());
            communicationDto.setPrimaryURL(outbound.getTransportURL());
            if (StringUtils.isNotBlank((CharSequence)outbound.getTransportFallbackURL())) {
                communicationDto.setFallbackURL(outbound.getTransportFallbackURL());
            }
            communicationDto.setUsername(outbound.getTransportAuthentication() != null ? outbound.getTransportAuthentication().getUser() : null);
            communicationDto.setPassword(outbound.getTransportAuthentication() != null ? outbound.getTransportAuthentication().getPassword() : null);
            communicationDto.setNumberOfRetries(outbound.getNumberOfRetries());
            communicationDto.setRetryIntervals(outbound.getRetryIntervals());
            Arrays.stream(outbound.getContentRules()).map(this.ruleDataDtoFactory::create).peek(ruleData -> ruleData.setActionType("ChangeDestinationURL")).forEach(communicationDto::addRule);
        }
        catch (CommunicationNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        return new CommunicationDtoHolder(agreement, communicationDto);
    }

    @Override
    public Agreement parse(CommunicationDtoHolder communicationDtoHolder) {
        Agreement agreement = communicationDtoHolder.getAgreement();
        CommunicationDto communicationDto = communicationDtoHolder.getCommunicationDto();
        try {
            Communication outbound = agreement.getCommunication(agreement.getPartner1LocalId(), agreement.getPartner2LocalId());
            agreement.setPingAllEnabled(communicationDto.isPingAllEnabled());
            outbound.setTransportURL(communicationDto.getPrimaryURL());
            outbound.setTransportFallbackURL(communicationDto.getFallbackURL());
            if ("***".equals(communicationDto.getPassword()) && communicationDto.getUsername() != null) {
                outbound.setTransportAuthentication(new Authentication(communicationDto.getUsername(), outbound.getTransportAuthentication().getPassword()));
            } else if (communicationDto.getUsername() != null && communicationDto.getPassword() != null) {
                outbound.setTransportAuthentication(new Authentication(communicationDto.getUsername(), communicationDto.getPassword()));
            } else if (communicationDto.getUsername() == null && communicationDto.getPassword() == null) {
                outbound.setTransportAuthentication(null);
            }
            outbound.setNumberOfRetries(communicationDto.getNumberOfRetries());
            outbound.setRetryIntervals(communicationDto.getRetryIntervals());
            ArrayList outboundContentRules = new ArrayList();
            communicationDto.getRules().stream().peek(ruleDataDto -> ruleDataDto.setIndex(outboundContentRules.size() + 1)).map(this.ruleDataDtoFactory::parse).peek(ruleData -> ruleData.setActionType("ChangeDestinationURL")).forEach(outboundContentRules::add);
            outbound.setContentRules(outboundContentRules.toArray(new RuleData[0]));
        }
        catch (CommunicationNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        return agreement;
    }
}

