/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.communication;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.rules.CommunicationRuleDataDto;
import de.ponton.xmlpipe.rest.cpa.validation.MinIntervalConstraint;
import de.ponton.xmlpipe.rest.jackson.ObfuscatedField;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.NullOrNotBlank;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="The communications settings of an agreement defines the parameters for the communication with other partners", name="Agreement.Communication")
public class CommunicationDto {
    @Schema(description="This flag controls if this agreement is considered for the PingAll feature. The flag has no effect if the global PingAll feature is disabled.")
    private boolean pingAllEnabled;
    @NotBlank
    @Pattern(regexp="(http://|https://|ftp://|ftps://|smime:|mailto:).+")
    @Schema(description="defines the primary URL where messages should be send to.")
    @TrimmedField
    private @NotBlank @Pattern(regexp="(http://|https://|ftp://|ftps://|smime:|mailto:).+") String primaryURL;
    @Pattern(regexp="(http://|https://|ftp://|ftps://|smime:|mailto:).+|")
    @Schema(description="defines the fallback URL where messages should be send to. It will be used when the primary URL is not reachable.")
    @TrimmedField
    private @Pattern(regexp="(http://|https://|ftp://|ftps://|smime:|mailto:).+|") String fallbackURL;
    @Schema(description="If the remote server requires user authorization, you can define the username and password here. Only the BASIC authorization protocol is supported.")
    @TrimmedField
    @NullOrNotBlank
    private String username;
    @Schema(description="If the remote server requires user authorization, you can define the username and password here. Only the BASIC authorization protocol is supported.")
    @ObfuscatedField
    @NullOrNotBlank
    private String password;
    @NotNull
    @Min(value=0L)
    @Schema(description="The number of retransmission attempts that are performed after the initial transmission fails")
    private @NotNull @Min(value=0L) Integer numberOfRetries;
    @NotNull
    @Size(min=1, max=5)
    @MinIntervalConstraint(value=5)
    @Schema(description="This defines the delay before another transmission attempt is started. It also affects how long the Messenger will wait for an acknowledgement.")
    private @NotNull @Size(min=1, max=5) List<Integer> retryIntervals;
    @Valid
    @NotNull
    @Schema(description="Communciation rules allow to override the receivers URL for transmitted messages. For each rule you define a XPATH whose value will be compared with VALUE by OPERATOR. The result of a regular XPATH will depend on the XML content that is received. There are special XPATH-expressions are available, which will not depend on the XML content and are instead set during the processing: '!MessageId', '!ConversationId', '!MessageType', '!MessageVersion', '!SchemaSet', '!TestFlag' and '!LogInfo'.")
    private @Valid @NotNull List<@Valid CommunicationRuleDataDto> rules = new ArrayList<CommunicationRuleDataDto>();

    public boolean isPingAllEnabled() {
        return this.pingAllEnabled;
    }

    public CommunicationDto setPingAllEnabled(boolean pingAllEnabled) {
        this.pingAllEnabled = pingAllEnabled;
        return this;
    }

    public String getPrimaryURL() {
        return this.primaryURL;
    }

    public CommunicationDto setPrimaryURL(String primaryURL) {
        this.primaryURL = primaryURL;
        return this;
    }

    public String getFallbackURL() {
        return this.fallbackURL;
    }

    public CommunicationDto setFallbackURL(String fallbackURL) {
        this.fallbackURL = fallbackURL;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public CommunicationDto setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public CommunicationDto setPassword(String password) {
        this.password = password;
        return this;
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public CommunicationDto setNumberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        return this;
    }

    public List<Integer> getRetryIntervals() {
        return this.retryIntervals;
    }

    public CommunicationDto setRetryIntervals(List<Integer> retryIntervals) {
        this.retryIntervals = retryIntervals;
        return this;
    }

    public CommunicationDto addRule(CommunicationRuleDataDto ruleDataDto) {
        this.rules.add(ruleDataDto);
        return this;
    }

    public List<CommunicationRuleDataDto> getRules() {
        return this.rules;
    }

    public CommunicationDto setRules(List<CommunicationRuleDataDto> rules) {
        this.rules = rules;
        return this;
    }
}

