/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class AgreementTemplateListItemDto {
    @Schema(description="The id of the Agreement Template")
    @TrimmedField
    @NotBlank
    private String agreementTemplateId;
    @Schema(description="true if this is the public part of the agreement template, false otherwise", required=true)
    private Boolean isPublic;
    @Schema(description="Flag indicating if the template is a custom template")
    private Boolean isCustom;
    @Schema(description="The timestamp of the last change for custom templates")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private OffsetDateTime lastModified;

    public String getAgreementTemplateId() {
        return this.agreementTemplateId;
    }

    public AgreementTemplateListItemDto setAgreementTemplateId(String agreementTemplateId) {
        this.agreementTemplateId = agreementTemplateId;
        return this;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public AgreementTemplateListItemDto setIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    public Boolean getIsCustom() {
        return this.isCustom;
    }

    public AgreementTemplateListItemDto setIsCustom(Boolean isCustom) {
        this.isCustom = isCustom;
        return this;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public AgreementTemplateListItemDto setLastModified(long lastModified) {
        this.lastModified = this.convertLastModifiedToOffsetDateTime(lastModified);
        return this;
    }

    private OffsetDateTime convertLastModifiedToOffsetDateTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atOffset(ZoneOffset.UTC);
    }
}

