/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.adapter;

import de.ponton.api.WebSocketAdapterInfo;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessFactory;
import de.pontonconsulting.xmlpipe.messenger.adapter.IAdapterAccess;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.AdapterInfoDAO;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.springframework.stereotype.Component;

@Component
public class AdapterInfoService {
    public static final String NEWLINE = "\\$NEWLINE\\$";
    private final AdapterRegistry adapterRegistry;
    private final AdapterInfoDAO adapterInfoDao;
    private final AdapterAccessFactory adapterAccessFactory;

    public AdapterInfoService(AdapterRegistry adapterRegistry, AdapterInfoDAO adapterInfoDao, AdapterAccessFactory adapterAccessFactory) {
        this.adapterRegistry = adapterRegistry;
        this.adapterInfoDao = adapterInfoDao;
        this.adapterAccessFactory = adapterAccessFactory;
    }

    public AdapterInfo getAdapter(String adapterId) {
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(adapterId);
        if (adapterInfo != null) {
            return adapterInfo;
        }
        throw new ResourceNotFoundException(String.format("Adapter not found. [AdapterId=%s]", adapterId));
    }

    public String getAdapterStatusMessage(String adapterId) throws AdapterAccessException {
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(adapterId);
        if (adapterInfo != null) {
            IAdapterAccess adapterAccess = this.adapterAccessFactory.getAdapterAccess(adapterInfo);
            return this.cleanAdapterStatus(adapterAccess.getStatusMessage());
        }
        throw new ResourceNotFoundException(String.format("Adapter not found. [AdapterId=%s]", adapterId));
    }

    public boolean getAdapterIsSelfCheckOk(String adapterId) throws AdapterAccessException {
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(adapterId);
        if (adapterInfo != null) {
            IAdapterAccess adapterAccess = this.adapterAccessFactory.getAdapterAccess(adapterInfo);
            return adapterAccess.isSelfCheckOk();
        }
        throw new ResourceNotFoundException(String.format("Adapter not found. [AdapterId=%s]", adapterId));
    }

    public List<AdapterInfo> getAllAdapters() {
        return Arrays.stream(this.adapterRegistry.getAllAdapters()).sorted(Comparator.comparing(AdapterInfo::getId)).collect(Collectors.toList());
    }

    public List<WebSocketAdapterInfo> getArchiveAdapters() {
        return this.getAllAdapters().stream().filter(AdapterInfo::supportsArchive).filter(adapterInfo -> adapterInfo instanceof WebSocketAdapterInfo).map(adapterInfo -> (WebSocketAdapterInfo)adapterInfo).collect(Collectors.toList());
    }

    public boolean deleteAdapter(String adapterId) throws DbException {
        if (this.adapterRegistry.getAdapter(adapterId) != null) {
            this.adapterInfoDao.removeAdapter(adapterId);
            return true;
        }
        return false;
    }

    protected String cleanAdapterStatus(String originAdapterStatus) {
        if (StringUtils.isNotBlank((CharSequence)originAdapterStatus)) {
            return Jsoup.parse((String)originAdapterStatus.replaceAll("<[bB][rR]/?>", NEWLINE)).text().replaceAll(NEWLINE, "\n");
        }
        return "";
    }
}

