/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.activation;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about the license state of the messenger.")
public class MessengerActivationDto {
    @Size(max=100)
    @NotNull
    @Schema(description="The name of the license")
    @TrimmedField
    private @Size(max=100) @NotNull String licenseName;
    @Schema(description="Indicator for a Trial license")
    private boolean trial;
    @Schema(description="Indicator if current license is activated. If license requires no activation, it is activated by default.")
    private boolean activated;
    @Schema(description="Indicates how many days the license is still valid.")
    private long daysLeft;
    @Schema(description="Specifies how many days the activation check may still be unsuccessful before the messenger is deactivated, which means that messages can neither be sent nor received. An unsuccessful activation check usually happens when the license server cannot be reached for some reason.")
    private long gracePeriod;
    @Schema(description="Indicator if the cluster mode of the Messenger is supported.")
    private boolean cluster;
    @Schema(description="Indicator if the ebXML 2.0 packager of the Messenger is supported.")
    private boolean ebxml2;
    @JsonProperty(value="as1_as2_as3")
    @Schema(description="Indicator if the AS1, AS2 and AS3 packager of the Messenger is supported.")
    private boolean as123;
    @Schema(description="Indicator if the AS4 packager of the Messenger is supported.")
    private boolean as4;
    @JsonProperty(value="as4_ec")
    @Schema(description="Indicator if AS4 Elliptic Curve option is supported.")
    private boolean as4EC;
    @Schema(description="Indicator if the plain packager of the Messenger is supported.")
    private boolean plain;
    @Schema(description="Maximum number of supported local partners")
    @Min(value=1L)
    private @Min(value=1L) int maximumLocalPartners;
    @Schema(description="Maximum number of supported remote partners")
    @Min(value=1L)
    private @Min(value=1L) int maximumRemotePartners;
    @Schema(description="Serial number of the Messenger license")
    private Long licenseSerialNumber;

    public String getLicenseName() {
        return this.licenseName;
    }

    public MessengerActivationDto setLicenseName(String licenseName) {
        this.licenseName = licenseName;
        return this;
    }

    public boolean isTrial() {
        return this.trial;
    }

    public MessengerActivationDto setTrial(boolean trial) {
        this.trial = trial;
        return this;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public MessengerActivationDto setActivated(boolean activated) {
        this.activated = activated;
        return this;
    }

    public long getDaysLeft() {
        return this.daysLeft;
    }

    public MessengerActivationDto setDaysLeft(long daysLeft) {
        this.daysLeft = daysLeft;
        return this;
    }

    public long getGracePeriod() {
        return this.gracePeriod;
    }

    public MessengerActivationDto setGracePeriod(long gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public MessengerActivationDto setCluster(boolean cluster) {
        this.cluster = cluster;
        return this;
    }

    public boolean isEbxml2() {
        return this.ebxml2;
    }

    public MessengerActivationDto setEbxml2(boolean ebxml2) {
        this.ebxml2 = ebxml2;
        return this;
    }

    public boolean isAs123() {
        return this.as123;
    }

    public MessengerActivationDto setAs123(boolean as123) {
        this.as123 = as123;
        return this;
    }

    public boolean isAs4() {
        return this.as4;
    }

    public MessengerActivationDto setAs4(boolean as4) {
        this.as4 = as4;
        return this;
    }

    public boolean isAs4EC() {
        return this.as4EC;
    }

    public MessengerActivationDto setAs4EC(boolean as4EC) {
        this.as4EC = as4EC;
        return this;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public MessengerActivationDto setPlain(boolean plain) {
        this.plain = plain;
        return this;
    }

    public int getMaximumLocalPartners() {
        return this.maximumLocalPartners;
    }

    public MessengerActivationDto setMaximumLocalPartners(int maximumLocalPartners) {
        this.maximumLocalPartners = maximumLocalPartners;
        return this;
    }

    public int getMaximumRemotePartners() {
        return this.maximumRemotePartners;
    }

    public MessengerActivationDto setMaximumRemotePartners(int maximumRemotePartners) {
        this.maximumRemotePartners = maximumRemotePartners;
        return this;
    }

    public Long getLicenseSerialNumber() {
        return this.licenseSerialNumber;
    }

    public MessengerActivationDto setLicenseSerialNumber(Long licenseSerialNumber) {
        this.licenseSerialNumber = licenseSerialNumber;
        return this;
    }
}

