/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.activation;

import de.ponton.xmlpipe.rest.activation.ActivationOrLicenseDto;
import de.ponton.xmlpipe.rest.activation.MessengerActivationDto;
import de.ponton.xmlpipe.rest.activation.MessengerActivationService;
import de.ponton.xmlpipe.rest.activation.MessengerLicenseService;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.config.DatabaseConfig;
import de.pontonconsulting.xmlpipe.events.activation.ValidateActivationEvent;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activation"})
@Validated
public class MessengerActivationController {
    public static final String DOCUMENTATION_TAG = "Activation";
    public static final String IGNORE_DBMS_PARAM = "ignoreDBMS";
    private static final Logger log = LogManager.getLogger((String)("Messenger." + MessengerActivationController.class.getName()));
    private static final String IGNORE_DBMS_QRY_PARAM = "ignoreDBMS=true";
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final MessengerActivationService messengerActivationService;
    private final MessengerLicenseService messengerLicenseService;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final DatabaseConfig databaseConfig;

    public MessengerActivationController(ExceptionDtoFactory exceptionDtoFactory, MessengerActivationService messengerActivationService, MessengerLicenseService messengerLicenseService, ApplicationEventPublisher applicationEventPublisher, DatabaseConfig databaseConfig) {
        this.exceptionDtoFactory = exceptionDtoFactory;
        this.messengerActivationService = messengerActivationService;
        this.messengerLicenseService = messengerLicenseService;
        this.applicationEventPublisher = applicationEventPublisher;
        this.databaseConfig = databaseConfig;
    }

    @GetMapping
    @Secured(value={"ACTIVATION_GET"})
    @Operation(summary="Get the Messenger Activation information", description="permission:ACTIVATION_GET<br><br>Returns the Messenger Activation information.", tags={"Activation"}, responses={@ApiResponse(responseCode="200", description="Get the MessengerActivation", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessengerActivationDto.class))})})
    public ResponseEntity<MessengerActivationDto> getMessengerActivation() throws ActivationException {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)this.messengerActivationService.getMessengerActivation());
    }

    @PostMapping(value={"/install"})
    @Secured(value={"ACTIVATION_INSTALL_POST"})
    @Validated
    @Operation(summary="Import messenger activation or license", description="permission:ACTIVATION_INSTALL_POST<br><br>Import the passed activation or license if the data format is valid. The exising license or activation is replaced", tags={"Activation"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<String> installActivationOrLicense(@RequestBody @Valid ActivationOrLicenseDto activationOrLicenseCertificate, HttpServletRequest httpServletRequest) throws ActivationException {
        if (this.messengerActivationService.isValidActivation(activationOrLicenseCertificate.getData())) {
            this.messengerActivationService.installActivation(activationOrLicenseCertificate.getData());
        } else if (this.messengerLicenseService.isValidLicense(activationOrLicenseCertificate.getData())) {
            this.checkDatabaseIsSupported(httpServletRequest);
            this.messengerLicenseService.installLicense(activationOrLicenseCertificate.getData());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @GetMapping(value={"/requestUpdate"})
    @Secured(value={"ACTIVATION_REQUEST_UPDATE_GET"})
    @Operation(summary="Generate a new Messenger activation request", description="permission:ACTIVATION_REQUEST_UPDATE_GET", tags={"Activation"})
    public ResponseEntity<ActivationOrLicenseDto> updateActivationRequest() throws ActivationException {
        return ResponseEntity.ok((Object)this.messengerActivationService.updateActivationRequest());
    }

    @PostMapping(value={"/sendActivationRequest"})
    @Secured(value={"ACTIVATION_REQUEST_UPDATE_GET"})
    @Operation(summary="Triggers an HTTPS request to the license server to get an updated license-activation. If the HTTPS request is not successful due to network restrictions, there will be no change to the current activation state.", description="permission:ACTIVATION_REQUEST_UPDATE_GET", tags={"Activation"})
    public ResponseEntity<Void> sendActivationRequest() {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ValidateActivationEvent(this).setForceActivation(true));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).build();
    }

    @ExceptionHandler(value={ActivationException.class})
    public ResponseEntity<ExceptionDto> handleActivationException(ActivationException e) {
        return new ResponseEntity((Object)this.exceptionDtoFactory.create((Throwable)e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private void checkDatabaseIsSupported(HttpServletRequest httpServletRequest) throws ActivationException {
        if (httpServletRequest != null && httpServletRequest.getQueryString() != null && httpServletRequest.getQueryString().contains(IGNORE_DBMS_QRY_PARAM)) {
            log.warn("Skipped DBMS-Check because of {} Query-Parameter", (Object)IGNORE_DBMS_QRY_PARAM);
            return;
        }
        String databaseUrl = this.databaseConfig.getUrl();
        if (databaseUrl.startsWith("jdbc:hsqldb:")) {
            throw new ActivationException(-1L, "HSQL database is not supported for productive use.");
        }
    }
}

