/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.ponton.xmlpipe.queue.IOueueMessageSender;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.OutboundQueueMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.OutboundQueueMessageDAO;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutboundQueueConsumer
implements Runnable,
AutoCloseable {
    private static final String ENV_PROPERTY_MAX_NUMBER_OF_THREADS = "OutboundQueueConsumer.maxNumberOfThreads";
    private static final String ENV_PROPERTY_MAINTENANCE_PERIOD = "OutboundQueueConsumer.maintenanceTaskPeriodInMillis";
    private static final int DEFAULT_MAINTENANCE_TASK_PERIOD_IN_MILLIS = 300000;
    private static final int DEFAULT_MAX_THREADS_PER_RECEIVER = 5;
    private static final long CLEANUP_INTERVAL = 900000L;
    private static final Logger log = LogManager.getLogger((String)"Messenger.OutboundQueueConsumer");
    private final int maintenanceTaskPeriodInMs;
    private final Supplier<Long> mainLoopWaitTime;
    private final int maxNumberOfThreads;
    private final OutboundQueueMessageDAO outboundQueueMessageDAO;
    private final Profiles profiles;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final AtomicBoolean newMessageEnqueued = new AtomicBoolean(false);
    private final Object threadPoolSizeLock = new Object();
    private final Object maintenanceTaskLock = new Object();
    private final Supplier<Boolean> maintenanceChecker;
    private final Supplier<Boolean> databaseIsAvailableChecker;
    private final IOueueMessageSender<OutboundQueueMessage> outboundMessageSender;
    private final Map<String, EndPointQueue> endpointInTransitQueues = new ConcurrentHashMap<String, EndPointQueue>();
    private final Set<Long> messagesInActiveTasks = new ConcurrentSkipListSet<Long>();
    private final ThreadPoolExecutor executor;
    private long lastCleanupOfEmptyQueues;
    private final ReferenceDateTask referenceDateTask;
    private final MessageDAO messageDAO;
    private final MetricsService metricsService;

    public OutboundQueueConsumer(ThreadPoolExecutor outboundThreadExecutor, OutboundQueueMessageDAO outboundQueueMessageDAO, Profiles profiles, int maxNumberOfThreads, Supplier<Boolean> maintenanceChecker, Supplier<Boolean> databaseIsAvailableChecker, IOueueMessageSender<OutboundQueueMessage> outboundMessageSender, ReferenceDateTask referenceDateTask, OutboundQueue outboundQueue, Supplier<Long> mainLoopWaitTime, MessageDAO messageDAO, MetricsService metricsService) {
        this.executor = outboundThreadExecutor;
        this.outboundQueueMessageDAO = outboundQueueMessageDAO;
        this.profiles = profiles;
        this.maintenanceChecker = maintenanceChecker;
        this.databaseIsAvailableChecker = databaseIsAvailableChecker;
        this.referenceDateTask = referenceDateTask;
        this.messageDAO = messageDAO;
        String systemProperty = System.getProperty(ENV_PROPERTY_MAX_NUMBER_OF_THREADS);
        this.maxNumberOfThreads = Objects.nonNull(systemProperty) ? Integer.parseInt(systemProperty) : maxNumberOfThreads;
        this.outboundMessageSender = outboundMessageSender;
        systemProperty = System.getProperty(ENV_PROPERTY_MAINTENANCE_PERIOD);
        this.maintenanceTaskPeriodInMs = Objects.nonNull(systemProperty) ? Integer.parseInt(systemProperty) : 300000;
        this.mainLoopWaitTime = mainLoopWaitTime;
        this.metricsService = metricsService;
        this.lastCleanupOfEmptyQueues = referenceDateTask.getReferenceCurrentTimeMillis();
        outboundQueueMessageDAO.setMessageEnqueuedNotifier(this::notifyNewMessageEnqueued);
        outboundQueueMessageDAO.setMessageFinishedNotifier(this::notifyNewMessageFinishedExternally);
        outboundQueue.setMessageInTransferCanceller(this::cancelMessageIfInTransfer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.initConsumer();
            String lastCheckedReceiverId = null;
            while (this.isRunning.get()) {
                log.trace("begin of while block");
                boolean exceptionOccurred = false;
                boolean newSendingTasksScheduled = false;
                boolean isMaintenanceMode = this.maintenanceChecker.get();
                if (!(!this.databaseIsAvailableChecker.get().booleanValue() || isMaintenanceMode && this.endpointInTransitQueues.isEmpty())) {
                    log.trace("begin of main if block");
                    try {
                        TreeSet<String> receivers = new TreeSet<String>();
                        if (isMaintenanceMode) {
                            receivers.addAll(this.outboundQueueMessageDAO.getReceiverWithInTransitMessages());
                        } else {
                            receivers.addAll(this.outboundQueueMessageDAO.getReceiverWithQueuedMessages());
                        }
                        log.trace("Retrieved current ReceiversList {}", receivers);
                        List<String> orderedReceiverIds = this.getOrderedReceiverIds(receivers, lastCheckedReceiverId);
                        for (String receiverId : orderedReceiverIds) {
                            int activeThreads = this.getRunningThreads();
                            if (activeThreads >= this.maxNumberOfThreads) {
                                log.debug("Interrupt processing of current ReceiverList, because MaxThreadPoolSize ({}) reached [activeTheadCount={} / lastCheckedReceiverId={}]", (Object)this.maxNumberOfThreads, (Object)activeThreads, (Object)lastCheckedReceiverId);
                                break;
                            }
                            lastCheckedReceiverId = receiverId;
                            EndPointQueue endPointQueue = this.endpointInTransitQueues.get(receiverId);
                            if (endPointQueue != null && endPointQueue.hasMessages() && this.handleReceiverMessagesInTransferQueue(endPointQueue)) {
                                newSendingTasksScheduled = true;
                                continue;
                            }
                            if (this.maintenanceChecker.get().booleanValue() || !this.handleNewPendingMessagesFromDB(receiverId, endPointQueue)) continue;
                            newSendingTasksScheduled = true;
                        }
                    }
                    catch (Exception e) {
                        log.error("{} while consuming OutboundMessages for receiver '{}': {}", (Object)e.getClass().getName(), lastCheckedReceiverId, (Object)e.getMessage(), (Object)e);
                        exceptionOccurred = true;
                    }
                }
                while (this.needsMainLoopWait(exceptionOccurred, newSendingTasksScheduled)) {
                    this.cleanupEmptyReceiverQueues();
                    this.waitAMoment();
                    exceptionOccurred = false;
                    newSendingTasksScheduled = true;
                }
                log.trace("end of while block");
            }
        }
        catch (Exception e) {
            log.error("{} while running OutboundQueueConsumer: {}", (Object)e.getClass().getName(), (Object)e.getMessage(), (Object)e);
        }
        finally {
            try {
                this.close();
            }
            catch (Exception e) {
                log.error("{} while closing OutboundQueueConsumer: {}", (Object)e.getClass().getName(), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private EndPointQueue getReceiverMessagesInTransferQueue(String receiverId) {
        return this.endpointInTransitQueues.compute(receiverId, (id, msgQueue) -> Objects.nonNull(msgQueue) ? msgQueue : new EndPointQueue());
    }

    private void cleanupEmptyReceiverQueues() {
        long now = this.referenceDateTask.getReferenceCurrentTimeMillis();
        if (now > 900000L + this.lastCleanupOfEmptyQueues) {
            this.lastCleanupOfEmptyQueues = now;
            this.endpointInTransitQueues.entrySet().removeIf(entry -> ((EndPointQueue)entry.getValue()).reservedMsgSize() == 0);
        }
    }

    List<String> getOrderedReceiverIds(SortedSet<String> receivers, String lastCheckedReceiverId) {
        TreeSet<String> tempReceivers = new TreeSet<String>(receivers);
        if (lastCheckedReceiverId == null) {
            return List.copyOf(tempReceivers);
        }
        boolean addedLastCheckedReceiverId = false;
        if (!tempReceivers.contains(lastCheckedReceiverId)) {
            tempReceivers.add(lastCheckedReceiverId);
            addedLastCheckedReceiverId = true;
        }
        ArrayList<String> helpList = new ArrayList<String>(tempReceivers);
        int index = helpList.indexOf(lastCheckedReceiverId);
        ArrayList<String> orderedReceiverIds = new ArrayList<String>();
        orderedReceiverIds.addAll(helpList.subList(index + 1, helpList.size()));
        orderedReceiverIds.addAll(helpList.subList(0, index + 1));
        if (addedLastCheckedReceiverId) {
            orderedReceiverIds.remove(lastCheckedReceiverId);
        }
        return orderedReceiverIds;
    }

    private boolean handleReceiverMessagesInTransferQueue(EndPointQueue endPointQueue) {
        if (endPointQueue == null) {
            return false;
        }
        OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
        OutboundQueueMessage messageToSend = null;
        for (int i = 0; i < endPointQueue.size(); ++i) {
            OutboundQueueMessage message = endPointQueue.touchNextMessage();
            if (this.messagesInActiveTasks.contains(message.getMessageId()) || message.isInTransfer() || !now.isAfter(message.getRetryTime())) continue;
            messageToSend = message;
            break;
        }
        if (messageToSend != null) {
            this.scheduleMessageSendThread(messageToSend);
            return true;
        }
        return false;
    }

    private boolean handleNewPendingMessagesFromDB(String receiverId, EndPointQueue receiverMessagesInTransfer) throws DbException {
        int receiverLimit = this.getReceiverLimit(receiverId, this.profiles);
        int receiverActiveThreads = receiverMessagesInTransfer == null ? 0 : receiverMessagesInTransfer.reservedMsgSize();
        int receiverAvailableThreads = Math.max(receiverLimit - receiverActiveThreads, 0);
        log.debug("Found {} available threads for receiver {} [receiverActiveThreads={} / receiverMaxThreads={}]", (Object)receiverAvailableThreads, (Object)receiverId, (Object)receiverActiveThreads, (Object)receiverLimit);
        int availableThreads = Math.min(receiverAvailableThreads, this.maxNumberOfThreads - this.getRunningThreads());
        boolean newSendingTasksScheduled = false;
        if (availableThreads > 0) {
            List<Long> nextMessageIds = this.outboundQueueMessageDAO.selectNextMessageIds(receiverId, Math.min(availableThreads, 5));
            for (Long nextMessageId : nextMessageIds) {
                this.scheduleMessageSendThread(nextMessageId, this.getReceiverMessagesInTransferQueue(receiverId));
                newSendingTasksScheduled = true;
            }
        }
        return newSendingTasksScheduled;
    }

    private int getReceiverLimit(String receiverId, Profiles profiles) {
        try {
            CppPartner partner = profiles.getProfileForLocalId(receiverId, true);
            if (Objects.nonNull(partner)) {
                return partner.getNumberOfParallelDeliveries();
            }
        }
        catch (ProfileException e) {
            log.error("Can't get profile for receiver {}: {}", (Object)receiverId, (Object)e.getMessage());
        }
        return 5;
    }

    private boolean needsMainLoopWait(boolean exceptionOccurred, boolean newSendingTasksScheduled) {
        if (!this.isRunning.get()) {
            return false;
        }
        if (!this.databaseIsAvailableChecker.get().booleanValue()) {
            log.trace("Database isn't available => wait MainLoop");
            return true;
        }
        if (this.maintenanceChecker.get().booleanValue()) {
            log.trace("maintenance is active => wait MainLoop");
            return true;
        }
        if (this.newMessageEnqueued.compareAndSet(true, false)) {
            log.trace("new OutboundMessage enqueued => NO MainLoop wait required");
            return false;
        }
        if (!newSendingTasksScheduled) {
            log.trace("No new SendingThreads scheduled => wait MainLoop");
            return true;
        }
        if (this.getRunningThreads() >= this.maxNumberOfThreads) {
            log.trace("Maximum number of sending threads ({}) reached => wait MainLoop", (Object)this.maxNumberOfThreads);
            return true;
        }
        if (exceptionOccurred) {
            log.trace("Exception occurred => wait MainLoop");
            return true;
        }
        return false;
    }

    private void initConsumer() {
        this.executor.execute(this::maintenanceTask);
        int msgInTransferCount = 0;
        try {
            List<OutboundQueueMessage> ownMessagesInTransfer = this.outboundQueueMessageDAO.getOwnMessagesInTransfer();
            msgInTransferCount = ownMessagesInTransfer.size();
            ownMessagesInTransfer.forEach(message -> {
                log.info("Found OutboundQueueRecord 'IN TRANSFER' and start SendingThread");
                this.getReceiverMessagesInTransferQueue(message.getReceiverId()).offer((OutboundQueueMessage)message);
                this.scheduleMessageSendThread((OutboundQueueMessage)message);
            });
        }
        catch (Exception e) {
            log.error("Can't load own messages 'IN TRANSFER' to init OutboundQueueConsumer: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Can't load own messages 'IN TRANSFER' to init OutboundQueueConsumer", e);
        }
        log.info("OutboundQueueConsumer initialized [ThreadPoolSize={} / runningThreads={} / maintenanceTaskPeriodInMs={} / maxNumberOfThreads={} / msgInTransferCount={}]", (Object)this.maxNumberOfThreads, (Object)this.getRunningThreads(), (Object)this.maintenanceTaskPeriodInMs, (Object)this.maxNumberOfThreads, (Object)msgInTransferCount);
    }

    private void scheduleMessageSendThread(OutboundQueueMessage outboundQueueMessage) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        outboundQueueMessage.setStatus(1);
        Future<?> sendingTask = this.executor.submit(() -> {
            Profiles.initThreadCache();
            Agreements.initThreadCache();
            try {
                countDownLatch.await();
                this.sendMessageInThread(outboundQueueMessage);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Interrupted while waiting for outbound queue thread", (Throwable)e);
            }
            finally {
                Agreements.clearThreadCache();
                Profiles.clearThreadCache();
                this.messagesInActiveTasks.remove(outboundQueueMessage.getMessageId());
            }
        });
        outboundQueueMessage.setSendingTask(sendingTask);
        this.messagesInActiveTasks.add(outboundQueueMessage.getMessageId());
        log.debug("Scheduled SendingTask for receiverId {} and messageId {}", (Object)outboundQueueMessage.getReceiverId(), (Object)outboundQueueMessage.getMessageId());
        countDownLatch.countDown();
    }

    private void scheduleMessageSendThread(long nextMessageId, EndPointQueue endPointQueue) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference sendingTaskReference = new AtomicReference();
        Future<?> sendingTask = this.executor.submit(() -> {
            Profiles.initThreadCache();
            Agreements.initThreadCache();
            try {
                countDownLatch.await();
                if (this.outboundQueueMessageDAO.startTransfer(nextMessageId)) {
                    OutboundQueueMessage outboundQueueMessage = this.outboundQueueMessageDAO.getMessageInTransfer(nextMessageId);
                    if (Objects.nonNull(outboundQueueMessage)) {
                        outboundQueueMessage.setSendingTask((Future)sendingTaskReference.get());
                        outboundQueueMessage.setStatus(1);
                        endPointQueue.offer(outboundQueueMessage);
                        this.sendMessageInThread(outboundQueueMessage);
                    } else {
                        log.debug("OutboundMessage {} with status 'IN TRANSFER' not found", (Object)nextMessageId);
                    }
                }
            }
            catch (DbException e) {
                log.error("Can't start outbound queue thread for message {}", (Object)nextMessageId, (Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Interrupted while waiting for outbound queue thread", (Throwable)e);
            }
            finally {
                Agreements.clearThreadCache();
                Profiles.clearThreadCache();
                endPointQueue.removeReservation(nextMessageId);
                this.messagesInActiveTasks.remove(nextMessageId);
            }
        });
        sendingTaskReference.set(sendingTask);
        endPointQueue.addReservation(nextMessageId);
        this.messagesInActiveTasks.add(nextMessageId);
        log.debug("Scheduled SendingTask for messageId {}", (Object)nextMessageId);
        countDownLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageInThread(OutboundQueueMessage outboundQueueMessage) {
        String receiverId = null;
        long messageDbId = outboundQueueMessage.getMessageId();
        MessageDAO.putDbIdToThreadContext(messageDbId);
        try {
            outboundQueueMessage.incNoOfRetries();
            receiverId = outboundQueueMessage.getReceiverId();
            IOueueMessageSender.SendingResult sendingTaskResult = this.outboundMessageSender.send(outboundQueueMessage);
            if (sendingTaskResult.isFinished()) {
                log.debug("Finish OutboundMessage {} for receiver {}", (Object)outboundQueueMessage.getMessageId(), (Object)receiverId);
                this.outboundQueueMessageDAO.finishMessageWithoutNotify(messageDbId);
                EndPointQueue endpointQueue = this.endpointInTransitQueues.get(receiverId);
                if (endpointQueue != null) {
                    endpointQueue.remove(outboundQueueMessage);
                }
                this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_QUEUE_REMOVE_RATE).mark();
            } else if (sendingTaskResult.isRetry()) {
                EndPointQueue endpointQueue = this.endpointInTransitQueues.get(receiverId);
                if (endpointQueue != null && endpointQueue.getMessage(outboundQueueMessage.getMessageId()) != null) {
                    outboundQueueMessage.setStatus(2);
                    outboundQueueMessage.setRetryTimeLong(sendingTaskResult.retryTime());
                    outboundQueueMessage.setTimeToLiveLong(sendingTaskResult.timeToLive());
                    log.debug("Retry OutboundMessage {} for receiver {} [retryTime={} / timeToLive={}]", (Object)messageDbId, (Object)receiverId, (Object)this.toOffsetDateTime(sendingTaskResult.retryTime()), (Object)this.toOffsetDateTime(sendingTaskResult.timeToLive()));
                } else {
                    log.debug("Finish OutboundMessage {} for receiver {}", (Object)outboundQueueMessage.getMessageId(), (Object)receiverId);
                }
            } else if (sendingTaskResult.isRescheduled()) {
                boolean rescheduledSuccessfully;
                EndPointQueue endpointQueue = this.endpointInTransitQueues.get(receiverId);
                if (endpointQueue != null) {
                    endpointQueue.remove(outboundQueueMessage);
                }
                if (rescheduledSuccessfully = this.outboundQueueMessageDAO.rescheduleMessage(messageDbId)) {
                    log.debug("Rescheduled OutboundMessage for receiver {}", (Object)receiverId);
                } else {
                    log.debug("Rescheduling of OutboundMessage for receiver {} not necessary, because OutboundMessage was finished already, by incoming AcK.", (Object)receiverId);
                }
            } else {
                log.error("SendingResult is neither 'FINISH', 'RETRY' nor 'RESCHEDULE': {}", (Object)sendingTaskResult);
            }
        }
        catch (Exception e) {
            log.error("Can't consume OutboundMessage for receiver {}: {}", (Object)receiverId, (Object)e.getMessage(), (Object)(log.isDebugEnabled() ? e : null));
            this.messageDAO.updateMessageStatus(messageDbId, "", 4);
            try {
                this.outboundQueueMessageDAO.finishMessageWithoutNotify(messageDbId);
            }
            catch (DbException ex) {
                log.error("Could delete message from queue for receiver {}: {}", (Object)receiverId, (Object)ex.getMessage(), (Object)(log.isDebugEnabled() ? ex : null));
            }
            this.endpointInTransitQueues.get(outboundQueueMessage.getReceiverId()).remove(outboundQueueMessage);
        }
        finally {
            MessageDAO.removeDbIdFromThreadContext();
            this.wakeUpMainLoop();
        }
    }

    private OffsetDateTime toOffsetDateTime(Long millis) {
        return Objects.isNull(millis) ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAMoment() {
        long waitTime;
        log.trace("begin of waitAMoment");
        try {
            waitTime = this.mainLoopWaitTime.get();
        }
        catch (Exception e) {
            waitTime = 5000L;
            log.error("Could not determine wait time for threads waiting. {}. Using default value: {}", (Object)e.toString(), (Object)waitTime);
        }
        Object object = this.threadPoolSizeLock;
        synchronized (object) {
            try {
                log.trace("Go to sleep for {} millis", (Object)waitTime);
                this.threadPoolSizeLock.wait(waitTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        log.trace("end of waitAMoment");
    }

    private void notifyNewMessageEnqueued() {
        this.newMessageEnqueued.getAndSet(true);
        this.wakeUpMainLoop();
    }

    private OutboundQueueMessage notifyNewMessageFinishedExternally(Long messageId) {
        for (EndPointQueue endPointQueue : this.endpointInTransitQueues.values()) {
            OutboundQueueMessage removedMessage = endPointQueue.remove(messageId);
            if (!Objects.nonNull(removedMessage)) continue;
            log.debug("Was finished externally and removed from MessageInTransfer list.");
            return removedMessage;
        }
        return null;
    }

    private Boolean cancelMessageIfInTransfer(Long messageId) {
        for (EndPointQueue endPointQueue : this.endpointInTransitQueues.values()) {
            OutboundQueueMessage queuedMessage = endPointQueue.getMessage(messageId);
            if (!Objects.nonNull(queuedMessage)) continue;
            if (queuedMessage.isInTransfer() && Objects.nonNull(queuedMessage.getSendingTask())) {
                log.warn("Running SendingTask was cancelled externally");
                queuedMessage.getSendingTask().cancel(true);
                return true;
            }
            return false;
        }
        return false;
    }

    List<String> getReceiverWithMessagesInTransfer() {
        return new ArrayList<String>(this.endpointInTransitQueues.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpMainLoop() {
        Object object = this.threadPoolSizeLock;
        synchronized (object) {
            try {
                this.threadPoolSizeLock.notifyAll();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpMaintenanceTask() {
        Object object = this.maintenanceTaskLock;
        synchronized (object) {
            try {
                this.maintenanceTaskLock.notifyAll();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintenanceTask() {
        while (this.isRunning.get()) {
            Object object = this.maintenanceTaskLock;
            synchronized (object) {
                try {
                    this.maintenanceTaskLock.wait(this.maintenanceTaskPeriodInMs);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                int deleted = this.outboundQueueMessageDAO.deleteFinishMessages();
                log.info("Deleted {} FINISHED OutboundMessages", (Object)deleted);
            }
            catch (DbException e) {
                log.error("{} while deleting finished messages: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
    }

    public int getRunningThreads() {
        return this.messagesInActiveTasks.size();
    }

    @Override
    public void close() throws Exception {
        log.info("Start closing OutboundQueueConsumer");
        this.isRunning.set(false);
        this.wakeUpMainLoop();
        this.wakeUpMaintenanceTask();
    }

    private static class EndPointQueue {
        private final Queue<OutboundQueueMessage> queue = new ConcurrentLinkedQueue<OutboundQueueMessage>();
        private final Map<Long, OutboundQueueMessage> messages = new ConcurrentHashMap<Long, OutboundQueueMessage>();
        private final Set<Long> reservedMsgs = new ConcurrentSkipListSet<Long>();

        private EndPointQueue() {
        }

        private synchronized void addReservation(long messageId) {
            this.reservedMsgs.add(messageId);
        }

        private synchronized void removeReservation(long messageId) {
            if (!this.messages.containsKey(messageId)) {
                this.reservedMsgs.remove(messageId);
            }
        }

        private synchronized void offer(OutboundQueueMessage message) {
            this.queue.offer(message);
            this.messages.put(message.getMessageId(), message);
            this.reservedMsgs.add(message.getMessageId());
        }

        public synchronized OutboundQueueMessage touchNextMessage() {
            OutboundQueueMessage message = this.queue.poll();
            this.queue.offer(message);
            return message;
        }

        private synchronized void remove(OutboundQueueMessage message) {
            this.queue.remove(message);
            this.messages.remove(message.getMessageId());
            this.reservedMsgs.remove(message.getMessageId());
        }

        private synchronized OutboundQueueMessage remove(long messageId) {
            OutboundQueueMessage removedMessage = this.messages.remove(messageId);
            if (removedMessage != null) {
                this.queue.remove(removedMessage);
                this.reservedMsgs.remove(removedMessage.getMessageId());
            }
            return removedMessage;
        }

        private boolean hasMessages() {
            return !this.queue.isEmpty();
        }

        public int size() {
            return this.queue.size();
        }

        public int reservedMsgSize() {
            return this.reservedMsgs.size();
        }

        public OutboundQueueMessage getMessage(Long messageId) {
            return this.messages.get(messageId);
        }
    }
}

