/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.ponton.xmlpipe.queue.IOueueMessageSender;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.ponton.xmlpipe.queue.XpMessageLoader;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.Util;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.OutboundQueueException;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.OutboundQueueMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.RemoteMaintenanceInterval;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpOutboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.database.tables.OutboundQueueMessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.RemoteMaintenanceIntervalDAO;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.IPackagingManager;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportProviderFactory;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;

public class OutboundMessageSender
implements IOueueMessageSender<OutboundQueueMessage> {
    private static final String NO_ACK_EXPECTED = "No Acknowledgement expected";
    private static final String WAITING_FOR_ACK = "Waiting for Acknowledgement";
    private static final String RECEIVER_REPORTED_ERROR = "Receiver reported an error: ";
    private static final String INTERNAL_TIMEOUT_MSG = "Local Timeout while sending";
    private static final int HTTP_CODE_413 = 413;
    private final Logger log = LogManager.getLogger((String)"Messenger.OutboundMessageSender");
    private final MetricsService metricsService;
    private final MessengerLog messengerLog;
    private final TransportProviderFactory transportProviderFactory;
    private final IFolders folders;
    private final ReferenceDateTask referenceDateTask;
    private final MessengerConfig messengerConfig;
    private final IPackagingManager packagingManager;
    private final MessageDAO messageDAO;
    private final ArchiveProcessor archiveProcessor;
    private final IdGenerator idGenerator;
    private final ReceiveFromListener receiveFromListener;
    private final XpMessageLoader xpMessageLoader;
    private final RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO;
    private final OutboundQueueMessageDAO outboundQueueMessageDAO;

    public OutboundMessageSender(MetricsService metricsService, MessengerLog messengerLog, TransportProviderFactory transportProviderFactory, IFolders folders, ReferenceDateTask referenceDateTask, MessengerConfig messengerConfig, IPackagingManager packagingManager, MessageDAO messageDAO, ArchiveProcessor archiveProcessor, IdGenerator idGenerator, ReceiveFromListener receiveFromListener, XpMessageLoader xpMessageLoader, RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO, OutboundQueueMessageDAO outboundQueueMessageDAO) {
        this.metricsService = metricsService;
        this.messengerLog = messengerLog;
        this.transportProviderFactory = transportProviderFactory;
        this.folders = folders;
        this.referenceDateTask = referenceDateTask;
        this.messengerConfig = messengerConfig;
        this.packagingManager = packagingManager;
        this.messageDAO = messageDAO;
        this.archiveProcessor = archiveProcessor;
        this.idGenerator = idGenerator;
        this.receiveFromListener = receiveFromListener;
        this.xpMessageLoader = xpMessageLoader;
        this.remoteMaintenanceIntervalDAO = remoteMaintenanceIntervalDAO;
        this.outboundQueueMessageDAO = outboundQueueMessageDAO;
    }

    /*
     * Exception decompiling
     */
    @Override
    public IOueueMessageSender.SendingResult send(OutboundQueueMessage outboundMessage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IOueueMessageSender.SendingResult decideFinishOrReschedule(OutboundQueueMessage outboundMessage, XpOutboundMessage xpMessage, String errorMessage) {
        boolean isPayloadTooLargeError;
        Optional<String> lastError = outboundMessage.getLastError();
        boolean bl = isPayloadTooLargeError = lastError.isPresent() && lastError.get().startsWith("Receiver reported an error: 413/");
        if (!xpMessage.isSignal() && this.messengerConfig.isRequeueFailedMessagesEnabled() && !isPayloadTooLargeError) {
            this.log.debug("Finished OutboundMessageSender with reschedule of mid:{}", (Object)xpMessage.getMessageId());
            return IOueueMessageSender.SendingResult.reschedule();
        }
        this.log.debug("Finished OutboundMessageSender of mid:{} [isSignal={} / messengerConfig.RequeueFailedMessagesEnabled={} / isPayloadTooLargeError={}]", (Object)xpMessage.getMessageId(), (Object)xpMessage.isSignal(), (Object)this.messengerConfig.isRequeueFailedMessagesEnabled(), (Object)isPayloadTooLargeError);
        this.createErrorAck(outboundMessage, xpMessage, errorMessage);
        return IOueueMessageSender.SendingResult.finished();
    }

    private void createErrorAck(OutboundQueueMessage outboundMessage, XpOutboundMessage xpMessage, String errorMessage) {
        this.log.debug("creating internal XpAcknowledgment for Timeout Error on mid:{}", (Object)xpMessage.getMessageId());
        String senderId = xpMessage.getSenderLocalId();
        if (senderId != null) {
            XpMessage newXpMessage = new XpMessage();
            newXpMessage.setIsAck(true);
            newXpMessage.setMessageId(this.idGenerator.generateMessageId());
            newXpMessage.setConversationId(xpMessage.getConversationId());
            newXpMessage.setSenderLocalId(senderId);
            newXpMessage.setReceiverLocalId(senderId);
            newXpMessage.setMessageType("ACK");
            newXpMessage.setMessageVersion("2.1");
            newXpMessage.setSchemaSet("ponton");
            newXpMessage.setInboundMessage(true);
            newXpMessage.setProtocol(OutboundQueue.PROTOCOL_INTERNAL);
            newXpMessage.setMessageTimestamp(this.referenceDateTask.getReferenceDate());
            newXpMessage.setReferenceId(xpMessage.getMessageId());
            newXpMessage.setReferenceDatabaseId(xpMessage.getDatabaseId());
            newXpMessage.setMessengerId(this.messengerConfig.getMessengerId());
            try {
                String destinationAdapter = this.messageDAO.getAdapterId(xpMessage.getDatabaseId());
                newXpMessage.setAdapterId(destinationAdapter);
                String transferId = this.messageDAO.getTransferId(xpMessage.getDatabaseId());
                newXpMessage.setTransferId(transferId);
                this.messageDAO.registerMessage(newXpMessage);
                this.messengerLog.log2db(206, xpMessage.getDatabaseId(), null);
                Date date = this.referenceDateTask.getReferenceDate();
                XpAcknowledgment ack = new XpAcknowledgment(newXpMessage, xpMessage.getMessageId(), date, date);
                ack.setOverallResult("Error");
                ack.addError("Error", errorMessage);
                outboundMessage.getLastError().ifPresent(e -> ack.addError("Error", (String)e));
                File ackRef = ack.saveToDisk(new File(this.folders.getWorkInboundFolder(), String.valueOf(newXpMessage.getDatabaseId())));
                newXpMessage.setCurrentContentReference(ackRef);
                this.receiveFromListener.handleMessage(newXpMessage);
            }
            catch (Exception e2) {
                this.log.error("{} occurred while creating internal timeout-ack:{}", (Object)e2.getClass().getName(), (Object)e2.getMessage(), (Object)e2);
            }
        }
    }

    private long prepareMessage(OutboundQueueMessage queueMessage, long currentTime, XpOutboundMessage xpMessage) throws OutboundQueueException {
        List<Integer> retryIntervals = xpMessage.getRetryIntervals();
        int maxNumberOfRetries = xpMessage.getMaxNumberOfRetries();
        long timeToLive = currentTime + Util.calculateTTL(maxNumberOfRetries, retryIntervals) * 1000L;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Setting time to live for message mid:'{}' to {} ({}) [maxNumberOfRetries={}]", (Object)xpMessage.getMessageId(), (Object)new Date(timeToLive), (Object)timeToLive, (Object)maxNumberOfRetries);
        }
        File work = new File(this.folders.getWorkOutboundFolder(), String.valueOf(queueMessage.getMessageId()));
        try {
            BasePackager somePackager = this.packagingManager.getPackager(xpMessage.getMessagePackaging());
            somePackager.storePostqueueingFormat(xpMessage.getCommunication(), timeToLive, work);
            this.log.debug("packaging completed");
        }
        catch (Exception e) {
            this.log.error("Could not package message mid:{} {}", (Object)xpMessage.getMessageId(), (Object)e, (Object)e);
            this.messengerLog.log2db(522, queueMessage.getMessageId(), "Could not package message: " + e.getMessage());
            throw new OutboundQueueException(e);
        }
        return timeToLive;
    }

    private Optional<SignCertInfo> getClientAuthenticationKey(XpOutboundMessage xpMessage) {
        try {
            return Optional.ofNullable(xpMessage.getCommunication().getClientAuthenticationKey());
        }
        catch (ActivationException | CommunicationNotFoundException | ProfileException | PackagingException | SecurityException | CertificateException e) {
            this.log.warn("could not prepare client certificate in agreement, client authentication disabled. {}", (Object)e.toString());
            return Optional.empty();
        }
    }

    private void handleTtlExpired(OutboundQueueMessage outboundMessage, XpOutboundMessage xpMessage, long currentTime, String transportUrl) {
        long messageId = outboundMessage.getMessageId();
        this.log.error("TimeToLive exceeded. (TTL:{} / current time:{}) Message mid:{} is failed", (Object)outboundMessage.getTimeToLive(), (Object)new Date(currentTime), (Object)xpMessage.getMessageId());
        try {
            xpMessage.getCommunication().setURLValid(transportUrl, false);
            this.log.warn("Invalidated URL '{}' of message mid:{}", (Object)transportUrl, (Object)xpMessage.getMessageId());
        }
        catch (CommunicationNotFoundException e) {
            this.log.error("Communication not found. {}", (Object)e.toString());
        }
    }

    private IOueueMessageSender.SendingResult handleResponse(ProviderResponse response, OutboundQueueMessage outboundMessage, XpOutboundMessage xpMessage, long nextRetryTime, long timeToLive) throws ActivationException, PackagingException, ProfileException {
        if (response.isAuthorizationFailed()) {
            String status = new String(response.getResponseMessage());
            this.log.error("Transmission failed due to authorisation problems:{}", (Object)status);
            outboundMessage.setLastError("Authorisation failed: " + status);
            this.messengerLog.log2db(501, outboundMessage.getMessageId(), "Authorisation failed: " + status);
            return IOueueMessageSender.SendingResult.retry(nextRetryTime, timeToLive);
        }
        if (!response.isFailed()) {
            String detail;
            this.log.info("Transmission was successful");
            if (Objects.requireNonNullElse(outboundMessage.getNoOfTries(), 0) == 2) {
                this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_RETRIES).mark();
                this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_RETRIES, xpMessage.getSenderLocalId()).mark();
            }
            if (xpMessage.isAckRequested()) {
                detail = WAITING_FOR_ACK;
            } else {
                this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_SUCCESSFUL).mark();
                this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_SENDER_SUCCESSFUL, xpMessage.getSenderLocalId()).mark();
                this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_RECEIVER_SUCCESSFUL, xpMessage.getReceiverLocalId()).mark();
                detail = NO_ACK_EXPECTED;
            }
            this.messengerLog.log2db(74, outboundMessage.getMessageId(), detail);
        } else {
            String endOfDowntime;
            this.log.error("Transmission failed");
            if (this.messengerConfig.isIgnoreMaintenanceHttpHeader() && (endOfDowntime = response.getHeaders().get("x-pontonxp-downtime-end")) != null) {
                this.remoteMaintenanceIntervalDAO.create(new RemoteMaintenanceInterval().setEndTime(Long.parseLong(endOfDowntime)).setStartTime(0L).setPartnerId(xpMessage.getReceiverLocalId()));
            }
        }
        BasePackager somePackager = this.packagingManager.getPackager(xpMessage.getMessagePackaging());
        if (!somePackager.handleTransmissionResponse(outboundMessage.getMessageId(), response)) {
            String responseStr = response.getResponseMessage() == null ? "" : Jsoup.parse((String)new String(response.getResponseMessage())).text();
            String transportResult = response.getHeaders().get("X-reply-text");
            if (transportResult == null) {
                transportResult = "";
            }
            String logText = RECEIVER_REPORTED_ERROR + transportResult + "/ " + responseStr;
            outboundMessage.setLastError(logText);
            this.messengerLog.log2db(501, outboundMessage.getMessageId(), logText);
        }
        if (!response.isFailed()) {
            if (!xpMessage.isAckRequested()) {
                this.archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), false);
                this.messageDAO.updateMessageStatus((long)outboundMessage.getMessageId(), xpMessage.getMessageId(), 3);
                this.messengerLog.log2db(102, outboundMessage.getMessageId(), null);
                this.log.info("outbound message processing completed (no ACK requested).");
                return IOueueMessageSender.SendingResult.finished();
            }
            this.log.debug("Outbound message was sent successfully, but Ack is required. Postpone until {} (retryTime)", (Object)new Date(nextRetryTime));
            nextRetryTime = timeToLive;
        }
        return IOueueMessageSender.SendingResult.retry(nextRetryTime, timeToLive);
    }
}

