/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

public interface IOueueMessageSender<T> {
    public SendingResult send(T var1);

    public record SendingResult(State state, Long retryTime, Long timeToLive) {
        public static SendingResult finished() {
            return new SendingResult(State.FINISHED, null, null);
        }

        public static SendingResult retry(long retryTime) {
            return new SendingResult(State.RETRY, retryTime, null);
        }

        public static SendingResult retry(long retryTime, Long timeToLive) {
            return new SendingResult(State.RETRY, retryTime, timeToLive);
        }

        public static SendingResult reschedule() {
            return new SendingResult(State.RESCHEDULE, null, null);
        }

        public boolean isFinished() {
            return this.state.isFinished();
        }

        public boolean isRetry() {
            return this.state.isRetry();
        }

        public boolean isRescheduled() {
            return this.state.isReschedule();
        }

        public static enum State {
            FINISHED,
            RETRY,
            RESCHEDULE;


            public boolean isFinished() {
                return this == FINISHED;
            }

            public boolean isRetry() {
                return this == RETRY;
            }

            public boolean isReschedule() {
                return this == RESCHEDULE;
            }
        }
    }
}

