/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.httpadapter;

import de.ponton.xmlpipe.httpadapter.HttpAdapter;
import de.ponton.xmlpipe.httpadapter.HttpAdapterAckMessage;
import de.ponton.xmlpipe.httpadapter.HttpAdapterAckQueue;
import de.ponton.xmlpipe.httpadapter.HttpAdapterInboundMessage;
import de.ponton.xmlpipe.httpadapter.HttpAdapterInboundQueue;
import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.ExtendedGenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.ExtendedMessageResult;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HttpAdapterController {
    private static final Logger LOGGER = LogManager.getLogger(HttpAdapterController.class);
    private static final String LOG_SET_HEADER = "Set header {}={}";
    private static final String DELETE_AFTER_CONFIRMATION = "X-DeleteAfterConfirmation";
    private static final String LAST_ID = "X-LastId";
    private static final String DOCUMENTATION_TAG = "HttpAdapter";
    private final HttpAdapter httpAdapter;
    private final ExtendedGenericAdapter genericAdapter;
    private final HttpAdapterInboundQueue inboundQueue;
    private final HttpAdapterAckQueue ackQueue;

    public HttpAdapterController(HttpAdapter httpAdapter, ExtendedGenericAdapter genericAdapter, HttpAdapterInboundQueue inboundQueue, HttpAdapterAckQueue ackQueue) {
        this.httpAdapter = httpAdapter;
        this.genericAdapter = genericAdapter;
        this.inboundQueue = inboundQueue;
        this.ackQueue = ackQueue;
    }

    @Secured(value={"HTTP_ADAPTER_INBOUND_GET"})
    @GetMapping(value={"/inbound"})
    @Operation(summary="Get the next received Message.", description="Get the next received Message.<br/><br/><b>permission:</b> HTTP_ADAPTER_INBOUND_GET", tags={"HttpAdapter"})
    @Parameters(value={@Parameter(in=ParameterIn.HEADER, description="Delete after confirmation flag. If the value of the header is true, the HttpAdapter delivers the same next message until the reception of the message is explicitly acknowledged by the client (see Request Header X-LastId ). Otherwise, the HttpAdapter delivers the next message without waiting for an acknowledgement. When this header does not exist, then no acknowledgement is expected.", name="X-DeleteAfterConfirmation", content={@Content(schema=@Schema(type="boolean"))}), @Parameter(in=ParameterIn.HEADER, description="Unique ID of the last received message. Use this header to acknowledge the last successfully received message (see Response Header X-Id).", name="X-LastId", content={@Content(schema=@Schema(type="integer"))})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The next received message.", headers={@Header(description="Content Type", name="Content-Type", required=true, schema=@Schema(type="string", example="application/xml")), @Header(description="Unique ID", name="X-Id", required=true, schema=@Schema(type="integer")), @Header(description="Message ID", name="X-MessageId", required=true, schema=@Schema(type="string")), @Header(description="Conversation ID", name="X-ConversationId", schema=@Schema(type="string")), @Header(description="Schemaset", name="X-SchemaSet", required=true, schema=@Schema(type="string")), @Header(description="Message Type", name="X-MessageType", required=true, schema=@Schema(type="string")), @Header(description="Message Version", name="X-MessageVersion", required=true, schema=@Schema(type="string")), @Header(description="Backend Sender ID", name="X-BackendSenderId", required=true, schema=@Schema(type="string")), @Header(description="Backend Receiver ID", name="X-BackendReceiverId", required=true, schema=@Schema(type="string")), @Header(description="Filename", name="X-Filename", schema=@Schema(type="string"))}, content={@Content}), @ApiResponse(responseCode="404", description="No messages queued."), @ApiResponse(responseCode="401", description="Unauthorized."), @ApiResponse(responseCode="403", description="Forbidden.")})
    public void inbound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Optional<HttpAdapterInboundMessage> nextInboundMessage;
        boolean waitForAck;
        Optional<String> deleteFlag = Optional.ofNullable(request.getHeader(DELETE_AFTER_CONFIRMATION));
        if (deleteFlag.isPresent()) {
            LOGGER.debug("Received header: {}={}", (Object)DELETE_AFTER_CONFIRMATION, (Object)deleteFlag.get());
            waitForAck = Boolean.parseBoolean(deleteFlag.get());
        } else {
            waitForAck = false;
        }
        Optional<String> lastId = Optional.ofNullable(request.getHeader(LAST_ID));
        lastId.ifPresent(s -> LOGGER.debug("Received header: {}={}", (Object)LAST_ID, s));
        if (lastId.isPresent()) {
            this.inboundQueue.deleteCurrentMessageByUniqueId(lastId.get());
        }
        if ((nextInboundMessage = this.inboundQueue.getNextMessage()).isPresent()) {
            Path metaInfoPath = nextInboundMessage.get().getMetaInfoPath();
            Path payloadPath = nextInboundMessage.get().getPayloadPath();
            if (Files.notExists(metaInfoPath, new LinkOption[0]) || Files.notExists(payloadPath, new LinkOption[0]) || !Files.isWritable(metaInfoPath) || !Files.isWritable(payloadPath)) {
                LOGGER.error("Some of internal files of the message with id {} are not accessible.", (Object)nextInboundMessage.get().getMessageUniqueId());
                this.inboundQueue.deleteCurrentMessageByUniqueId(nextInboundMessage.get().getMessageUniqueId());
                response.setStatus(404);
                return;
            }
            this.streamMessage(response, metaInfoPath, payloadPath);
            response.setStatus(200);
            LOGGER.info("Received inbound message with ID '{}'", (Object)nextInboundMessage.get().getMessageUniqueId());
            if (!waitForAck) {
                this.inboundQueue.deleteCurrentMessageByUniqueId(nextInboundMessage.get().getMessageUniqueId());
            }
        } else {
            LOGGER.debug("No messages queued.");
            response.setStatus(404);
        }
    }

    @Secured(value={"HTTP_ADAPTER_ACK_GET"})
    @GetMapping(value={"/ack"})
    @Operation(summary="Get the next received ACK.", description="Get the next received ACK.<br/><br/><b>permission:</b> HTTP_ADAPTER_ACK_GET", tags={"HttpAdapter"})
    @Parameters(value={@Parameter(in=ParameterIn.HEADER, description="Delete after confirmation flag. If the value of the header is true, the HttpAdapter delivers the same next ACK until the reception of the ACK is explicitly acknowledged by the client (see Request Header X-LastId ). Otherwise, the HttpAdapter delivers the next ACK without waiting for an acknowledgement. When this header does not exist, then no acknowledgement is expected.", name="X-DeleteAfterConfirmation", content={@Content(schema=@Schema(type="boolean"))}), @Parameter(in=ParameterIn.HEADER, description="Unique ID of the last received message. Use this header to acknowledge the last successfully received ACK (see Response Header X-Id).", name="X-LastId", content={@Content(schema=@Schema(type="integer"))})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The next received ACK.", headers={@Header(description="Content Type", name="Content-Type", required=true, schema=@Schema(contentMediaType="application/xml")), @Header(description="ACK Unique ID", name="X-Id", required=true, schema=@Schema(type="integer")), @Header(description="ACK Message ID", name="X-MessageId", required=true, schema=@Schema(type="string")), @Header(description="Conversation ID", name="X-ConversationId", schema=@Schema(type="string")), @Header(description="Unique ID of the sent Message", name="X-RefId", required=true, schema=@Schema(type="integer")), @Header(description="Message ID of the sent Message", name="X-RefMessageId", required=true, schema=@Schema(type="string")), @Header(description="Schemaset of the sent Message", name="X-RefSchemaSet", required=true, schema=@Schema(type="string")), @Header(description="Message Type of the sent Message", name="X-RefMessageType", required=true, schema=@Schema(type="string")), @Header(description="Message Version of the sent Message", name="X-RefMessageVersion", required=true, schema=@Schema(type="string")), @Header(description="Backend Sender ID of the sent Message", name="X-RefBackendSenderId", required=true, schema=@Schema(type="string")), @Header(description="Backend Receiver ID of the sent Message", name="X-RefBackendReceiverId", required=true, schema=@Schema(type="string"))}, content={@Content}), @ApiResponse(responseCode="404", description="No ACKs queued."), @ApiResponse(responseCode="401", description="Unauthorized."), @ApiResponse(responseCode="403", description="Forbidden.")})
    public void ack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Optional<HttpAdapterAckMessage> nextAckMessage;
        boolean waitForAck;
        Optional<String> deleteFlag = Optional.ofNullable(request.getHeader(DELETE_AFTER_CONFIRMATION));
        if (deleteFlag.isPresent()) {
            LOGGER.debug("Received header: {}={} to get ack", (Object)DELETE_AFTER_CONFIRMATION, (Object)deleteFlag.get());
            waitForAck = Boolean.parseBoolean(deleteFlag.get());
        } else {
            waitForAck = false;
        }
        Optional<String> lastId = Optional.ofNullable(request.getHeader(LAST_ID));
        lastId.ifPresent(s -> LOGGER.debug("Received header: {}={} to get ack", (Object)LAST_ID, s));
        if (lastId.isPresent()) {
            this.ackQueue.deleteCurrentAckByUniqueId(lastId.get());
        }
        if ((nextAckMessage = this.ackQueue.getNextMessage()).isPresent()) {
            Path metaInfoPath = nextAckMessage.get().getMetaInfoPath();
            Path payloadPath = nextAckMessage.get().getPayloadPath();
            if (Files.notExists(metaInfoPath, new LinkOption[0]) || Files.notExists(payloadPath, new LinkOption[0]) || !Files.isWritable(metaInfoPath) || !Files.isWritable(payloadPath)) {
                LOGGER.error("Some of internal files of the ack message with id {} are not accessible.", (Object)nextAckMessage.get().getMessageUniqueId());
                this.ackQueue.deleteCurrentAckByUniqueId(nextAckMessage.get().getMessageUniqueId());
                response.setStatus(404);
                return;
            }
            this.streamMessage(response, metaInfoPath, payloadPath);
            response.setStatus(200);
            LOGGER.info("Received ack message with ID '{}'", (Object)nextAckMessage.get().getMessageUniqueId());
            if (!waitForAck) {
                this.ackQueue.deleteCurrentAckByUniqueId(nextAckMessage.get().getMessageUniqueId());
            }
        } else {
            LOGGER.debug("No ack messages queued.");
            response.setStatus(404);
        }
    }

    private void streamMessage(HttpServletResponse response, Path metaInfoPath, Path payloadPath) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(metaInfoPath, new OpenOption[0]);){
            properties.load(inputStream);
        }
        properties.keySet().stream().map(Object::toString).forEach(key -> response.setHeader(key, this.encodeHeaderValue(properties.getProperty((String)key))));
        inputStream = new BufferedInputStream(Files.newInputStream(payloadPath, new OpenOption[0]));
        try {
            inputStream.transferTo((OutputStream)response.getOutputStream());
        }
        finally {
            inputStream.close();
        }
    }

    @Secured(value={"HTTP_ADAPTER_OUTBOUND_POST"})
    @PostMapping(value={"/outbound"})
    @Operation(summary="Send Message.", description="Send Message.<br/><br/><b>permission:</b> HTTP_ADAPTER_OUTBOUND_POST", tags={"HttpAdapter"})
    @Parameters(value={@Parameter(in=ParameterIn.HEADER, description="Content Type", name="Content-Type", content={@Content(schema=@Schema(type="string", example="application/xml"))}), @Parameter(in=ParameterIn.HEADER, description="Message ID", name="X-MessageId", content={@Content(schema=@Schema(type="string"))}), @Parameter(in=ParameterIn.HEADER, description="Conversation ID", name="X-ConversationId", content={@Content(schema=@Schema(type="string"))}), @Parameter(in=ParameterIn.HEADER, description="Schemaset", name="X-SchemaSet", content={@Content(schema=@Schema(type="string"))}), @Parameter(in=ParameterIn.HEADER, description="Message Type", name="X-MessageType", content={@Content(schema=@Schema(type="string"))}), @Parameter(in=ParameterIn.HEADER, description="Message Version", name="X-MessageVersion", content={@Content(schema=@Schema(type="string"))}), @Parameter(in=ParameterIn.HEADER, description="Backend Sender ID", name="X-BackendSenderId", content={@Content(schema=@Schema(type="string"))}), @Parameter(in=ParameterIn.HEADER, description="Backend Receiver ID", name="X-BackendReceiverId", content={@Content(schema=@Schema(type="string"))}), @Parameter(in=ParameterIn.HEADER, description="Filename", name="X-Filename", content={@Content(schema=@Schema(type="string"))})})
    @RequestBody(description="Message Content.", required=true, content={@Content(mediaType="application/octet-stream", schema=@Schema(type="string", format="binary"))})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Message successfully processed.", headers={@Header(description="Message ID", name="X-MessageId", required=true, schema=@Schema(type="string")), @Header(description="Conversation ID", name="X-ConversationId", schema=@Schema(type="string")), @Header(description="Schemaset", name="X-SchemaSet", required=true, schema=@Schema(type="string")), @Header(description="Message Type", name="X-MessageType", required=true, schema=@Schema(type="string")), @Header(description="Message Version", name="X-MessageVersion", required=true, schema=@Schema(type="string")), @Header(description="Backend Sender ID", name="X-BackendSenderId", required=true, schema=@Schema(type="string")), @Header(description="Backend Receiver ID", name="X-BackendReceiverId", required=true, schema=@Schema(type="string"))}), @ApiResponse(responseCode="400", description="Message could not be processed.", content={@Content}, headers={@Header(description="Message ID", name="X-MessageId", schema=@Schema(type="string")), @Header(description="Conversation ID", name="X-ConversationId", schema=@Schema(type="string")), @Header(description="Schemaset", name="X-SchemaSet", schema=@Schema(type="string")), @Header(description="Message Type", name="X-MessageType", schema=@Schema(type="string")), @Header(description="Message Version", name="X-MessageVersion", schema=@Schema(type="string")), @Header(description="Backend Sender ID", name="X-BackendSenderId", schema=@Schema(type="string")), @Header(description="Backend Receiver ID", name="X-BackendReceiverId", schema=@Schema(type="string"))}), @ApiResponse(responseCode="401", description="Unauthorized."), @ApiResponse(responseCode="403", description="Forbidden.")})
    public void outbound(HttpServletRequest request, HttpServletResponse response) throws IOException, BackEndMessageException, AdapterException {
        Path payloadFile = Files.createTempFile(this.httpAdapter.getOutboundFolder(), "payload", ".dat", new FileAttribute[0]);
        try {
            Optional<String> messageId = this.getValueFor(request, "X-MessageId");
            Optional<String> conversationId = this.getValueFor(request, "X-ConversationId");
            Optional<String> schemaSet = this.getValueFor(request, "X-SchemaSet");
            Optional<String> messageType = this.getValueFor(request, "X-MessageType");
            Optional<String> messageVersion = this.getValueFor(request, "X-MessageVersion");
            Optional<String> backendSenderId = this.getValueFor(request, "X-BackendSenderId");
            Optional<String> backendReceiverId = this.getValueFor(request, "X-BackendReceiverId");
            Optional<String> filename = this.getValueFor(request, "X-Filename");
            try (OutputStream outputStream = Files.newOutputStream(payloadFile, new OpenOption[0]);){
                request.getInputStream().transferTo(outputStream);
            }
            String contentType = request.getHeader("Content-Type");
            boolean isXml = contentType != null && new ContentType(contentType).getSubType().equalsIgnoreCase("xml");
            BackEndMessage backEndMessage = new BackEndMessage(payloadFile.toFile(), isXml);
            messageId.ifPresent(arg_0 -> ((BackEndMessage)backEndMessage).setTransferID(arg_0));
            conversationId.ifPresent(arg_0 -> ((BackEndMessage)backEndMessage).setConversationID(arg_0));
            schemaSet.ifPresent(arg_0 -> ((BackEndMessage)backEndMessage).setDTDSet(arg_0));
            messageType.ifPresent(arg_0 -> ((BackEndMessage)backEndMessage).setMessageName(arg_0));
            messageVersion.ifPresent(arg_0 -> ((BackEndMessage)backEndMessage).setDTDVersionNumber(arg_0));
            backendSenderId.ifPresent(arg_0 -> ((BackEndMessage)backEndMessage).setSenderOrganisation(arg_0));
            backendReceiverId.ifPresent(arg_0 -> ((BackEndMessage)backEndMessage).setReceiverOrganisation(arg_0));
            filename.ifPresent(value -> backEndMessage.addProcessingDirective("OriginalFilename", value));
            ExtendedMessageResult messageResult = this.genericAdapter.sendMessageExtended(backEndMessage);
            this.setReceivedParameters(response, messageResult);
            if (messageResult.getXpCode() == MessageResult.MSG_SUCCESSFULLY_SEND.getXpCode()) {
                response.setStatus(204);
                LOGGER.info("Successfully sent message with the MessageId '{}'.", messageId);
            } else {
                LOGGER.error("Could note send message with the MessageId '{}': {}", messageId, (Object)messageResult.getDescription());
                response.setHeader("Content-Type", "text/plain; charset=\"utf-8\"");
                response.getOutputStream().write(messageResult.getDescription().getBytes(StandardCharsets.UTF_8));
                response.setStatus(400);
            }
        }
        catch (ParseException e) {
            LOGGER.error("content-type header has invalid content {}", (Object)e.getMessage());
            throw new AdapterException((Throwable)e);
        }
        finally {
            Files.deleteIfExists(payloadFile);
        }
    }

    private void setReceivedParameters(HttpServletResponse response, ExtendedMessageResult messageResult) {
        String backendReceiverId;
        String backendSenderId;
        String messageVersion;
        String messageType;
        String schemaSet;
        String conversationId;
        String messageId = messageResult.getMessageId();
        if (StringUtils.isNotBlank((CharSequence)messageId)) {
            response.setHeader("X-MessageId", this.encodeHeaderValue(messageId));
            LOGGER.debug(LOG_SET_HEADER, (Object)"X-MessageId", (Object)messageId);
        }
        if (StringUtils.isNotBlank((CharSequence)(conversationId = messageResult.getConversationId()))) {
            response.setHeader("X-ConversationId", this.encodeHeaderValue(conversationId));
            LOGGER.debug(LOG_SET_HEADER, (Object)"X-ConversationId", (Object)conversationId);
        }
        if (StringUtils.isNotBlank((CharSequence)(schemaSet = messageResult.getSchemaSet()))) {
            response.setHeader("X-SchemaSet", this.encodeHeaderValue(schemaSet));
            LOGGER.debug(LOG_SET_HEADER, (Object)"X-SchemaSet", (Object)schemaSet);
        }
        if (StringUtils.isNotBlank((CharSequence)(messageType = messageResult.getMessageType()))) {
            response.setHeader("X-MessageType", this.encodeHeaderValue(messageType));
            LOGGER.debug(LOG_SET_HEADER, (Object)"X-MessageType", (Object)messageType);
        }
        if (StringUtils.isNotBlank((CharSequence)(messageVersion = messageResult.getSchemaVersion()))) {
            response.setHeader("X-MessageVersion", this.encodeHeaderValue(messageVersion));
            LOGGER.debug(LOG_SET_HEADER, (Object)"X-MessageVersion", (Object)messageVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)(backendSenderId = messageResult.getSenderId()))) {
            response.setHeader("X-BackendSenderId", this.encodeHeaderValue(backendSenderId));
            LOGGER.debug(LOG_SET_HEADER, (Object)"X-BackendSenderId", (Object)backendSenderId);
        }
        if (StringUtils.isNotBlank((CharSequence)(backendReceiverId = messageResult.getReceiverId()))) {
            response.setHeader("X-BackendReceiverId", this.encodeHeaderValue(backendReceiverId));
            LOGGER.debug(LOG_SET_HEADER, (Object)"X-BackendReceiverId", (Object)backendReceiverId);
        }
    }

    private Optional<String> getValueFor(HttpServletRequest request, String headerName) {
        String headerValue = request.getHeader(headerName);
        if (headerValue == null) {
            return Optional.empty();
        }
        LOGGER.debug("Received header {}={}", (Object)headerName, (Object)headerValue);
        return Optional.of(this.decodeHeaderValue(headerValue));
    }

    private String decodeHeaderValue(String headerValue) {
        return headerValue;
    }

    private String encodeHeaderValue(String headerValue) {
        return headerValue;
    }
}

