/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.httpadapter;

import de.ponton.xmlpipe.httpadapter.HttpAdapterAckQueue;
import de.ponton.xmlpipe.httpadapter.HttpAdapterConfig;
import de.ponton.xmlpipe.httpadapter.HttpAdapterInboundQueue;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class HttpAdapter
implements ISpecificAdapter {
    private static final Logger logger = LogManager.getLogger(HttpAdapter.class);
    public static final String ID = "X-Id";
    public static final String MESSAGE_ID = "X-MessageId";
    public static final String REF_ID = "X-RefId";
    public static final String REF_MESSAGE_ID = "X-RefMessageId";
    public static final String CONVERSATION_ID = "X-ConversationId";
    public static final String SCHEMA_SET = "X-SchemaSet";
    public static final String REF_SCHEMA_SET = "X-RefSchemaSet";
    public static final String MESSAGE_TYPE = "X-MessageType";
    public static final String REF_MESSAGE_TYPE = "X-RefMessageType";
    public static final String MESSAGE_VERSION = "X-MessageVersion";
    public static final String REF_MESSAGE_VERSION = "X-RefMessageVersion";
    public static final String BACKEND_SENDER_ID = "X-BackendSenderId";
    public static final String REF_BACKEND_SENDER_ID = "X-RefBackendSenderId";
    public static final String BACKEND_RECEIVER_ID = "X-BackendReceiverId";
    public static final String REF_BACKEND_RECEIVER_ID = "X-RefBackendReceiverId";
    public static final String FILENAME = "X-Filename";
    public static final String SEPARATOR = "_";
    public static final String META_INFO_SUFFIX = "_meta_info";
    public static final String PAYLOAD_SUFFIX = "_payload";
    private Path workFolder;
    private Path outboundFolder;
    private final IServerConfigBean serverConfig;
    private final HttpAdapterConfig httpAdapterConfig;
    private final HttpAdapterInboundQueue inboundQueue;
    private final HttpAdapterAckQueue ackQueue;

    public HttpAdapter(IServerConfigBean serverConfig, HttpAdapterConfig httpAdapterConfig, HttpAdapterInboundQueue inboundQueue, HttpAdapterAckQueue ackQueue) {
        this.serverConfig = serverConfig;
        this.httpAdapterConfig = httpAdapterConfig;
        this.inboundQueue = inboundQueue;
        this.ackQueue = ackQueue;
    }

    @PostConstruct
    protected void init() throws IOException {
        this.workFolder = this.serverConfig.getRealFile(this.httpAdapterConfig.getWorkFolder()).toPath();
        if (!Files.exists(this.workFolder, new LinkOption[0])) {
            Files.createDirectories(this.workFolder, new FileAttribute[0]);
            logger.info("Created work folder: {}", (Object)this.workFolder);
        } else if (!Files.isDirectory(this.workFolder, new LinkOption[0])) {
            throw new IOException("The defined work folder is a file: " + this.workFolder.toString());
        }
        this.outboundFolder = this.serverConfig.getRealFile(this.httpAdapterConfig.getOutboundFolder()).toPath();
        if (!Files.exists(this.outboundFolder, new LinkOption[0])) {
            Files.createDirectories(this.outboundFolder, new FileAttribute[0]);
            logger.info("Created outbound folder: {}", (Object)this.outboundFolder);
        } else if (!Files.isDirectory(this.outboundFolder, new LinkOption[0])) {
            throw new IOException("The defined outbound folder is a file: " + this.outboundFolder.toString());
        }
    }

    public String getID() {
        return this.httpAdapterConfig.getAdapterId();
    }

    public String getStatus() {
        try {
            return this.inboundQueue.getQueueSize() + " queued messages. : " + this.ackQueue.getQueueSize() + " queued acks";
        }
        catch (IOException e) {
            logger.error("Could not determine inbound queue size: {}.", (Object)e.toString());
            return "Could not get queue size: " + String.valueOf(e);
        }
    }

    public boolean supportsAcknowledgements() {
        return this.httpAdapterConfig.getReceiveAck();
    }

    public boolean supportsAttachments() {
        return false;
    }

    public int getNumberOfParallelThreads() {
        return this.httpAdapterConfig.getNumberOfParallelThreads();
    }

    public MessageResult receiveMessage(BackEndMessage message) {
        return this.inboundQueue.addMessage(message);
    }

    public MessageResult receiveTestMessage(BackEndMessage message) {
        return this.receiveMessage(message);
    }

    public MessageResult receiveAcknowledgement(BackEndMessage message) {
        return this.ackQueue.addMessage(message);
    }

    public File getWorkFolder() {
        return this.workFolder.toFile();
    }

    public boolean doSelfCheck() {
        return true;
    }

    public String shutdown() {
        return "done";
    }

    public Path getOutboundFolder() {
        return this.outboundFolder;
    }

    public int getProcessingTimeout() {
        return this.httpAdapterConfig.getProcessingTimeout();
    }
}

