/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket.messages;

import de.ponton.api.WebSocketAdapterInfo;
import de.ponton.api.websocket.WebSocketAdapterAccessException;
import de.ponton.api.websocket.WebSocketConnection;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.adapter.util.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.DuplicateInProcessException;
import de.pontonconsulting.xmlpipe.messenger.DuplicateInProcessGuardian;
import de.pontonconsulting.xmlpipe.messenger.MessageRegistrationService;
import de.pontonconsulting.xmlpipe.messenger.SendToListener;
import de.pontonconsulting.xmlpipe.messenger.SendToListenerResult;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageRecognitionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class OutboundMessageWorker
implements Runnable {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.OutboundMessageWorker");
    private static final String PROPERTY_RFC2822_CONFORM_MESSAGE_ID = "ponton.rfc2822.conform.message.id";
    private static final String DEFAULT_RFC2822_CONFORM_MESSAGE_ID = "true";
    private final File dataFile;
    private final SimpleProperties messageMetaData;
    private final WebSocketAdapterInfo adapterInfo;
    private final SendToListener sendToListener;
    private final IMessengerProperties messengerProperties;
    private final TempFileCreator tempFileCreator;
    private final CountDownLatch executionSignal = new CountDownLatch(1);
    private final DuplicateInProcessGuardian duplicateInProcessGuardian;
    private final MessageRegistrationService messageRegistrationService;

    OutboundMessageWorker(File dataFile, SimpleProperties messageMetaData, WebSocketAdapterInfo adapterInfo, SendToListener sendToListener, IMessengerProperties messengerProperties, TempFileCreator tempFileCreator, DuplicateInProcessGuardian duplicateInProcessGuardian, MessageRegistrationService messageRegistrationService) {
        this.dataFile = dataFile;
        this.messageMetaData = messageMetaData;
        this.adapterInfo = adapterInfo;
        this.sendToListener = sendToListener;
        this.messengerProperties = messengerProperties;
        this.tempFileCreator = tempFileCreator;
        this.duplicateInProcessGuardian = duplicateInProcessGuardian;
        this.messageRegistrationService = messageRegistrationService;
    }

    public void startExecution() {
        this.executionSignal.countDown();
    }

    @Override
    public void run() {
        try {
            this.executionSignal.await(5L, TimeUnit.SECONDS);
            SendToListenerResult sendToListenerResult = this.processOutboundMessage();
            WebSocketConnection connection = this.adapterInfo.borrowInboundConnection();
            try {
                this.sendStatusUpdate(sendToListenerResult, connection);
            }
            finally {
                this.adapterInfo.releaseInboundConnection(connection);
            }
        }
        catch (WebSocketAdapterAccessException e) {
            LOG.error("could not borrow connection for status update for message with transfer ID {}", (Object)this.messageMetaData.getProperty(AdapterPropertiesEnum.TRANSFER_ID), (Object)e);
        }
        catch (RuntimeException e) {
            LOG.error("could not process message {}", (Object)this.messageMetaData.getProperty(AdapterPropertiesEnum.TRANSFER_ID), (Object)e);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SendToListenerResult processOutboundMessage() {
        Profiles.initThreadCache();
        Agreements.initThreadCache();
        try {
            LOG.debug("starting outbound processing");
            String transferId = this.messageMetaData.getProperty(AdapterPropertiesEnum.TRANSFER_ID);
            XpMessage tempMessage = this.messageRegistrationService.registerMessageFromAdapter(this.adapterInfo.getId(), transferId);
            XpMessage xpMessage = this.convertSimplePropertiesToXpMessage(this.messageMetaData);
            xpMessage.setCurrentContentReference(this.dataFile);
            xpMessage.setAdapterId(this.adapterInfo.getId());
            xpMessage.setDatabaseId(tempMessage.getDatabaseId());
            xpMessage.setRegistrationTimestamp(tempMessage.getRegistrationTimestamp());
            String messageId = xpMessage.getMessageId();
            try {
                this.duplicateInProcessGuardian.startProcess(messageId);
            }
            catch (DuplicateInProcessException e) {
                String errorText = "Message with same message id (%s) is currently being processed.".formatted(xpMessage.getMessageId());
                this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, errorText);
                SendToListenerResult sendToListenerResult = new SendToListenerResult(SendToListenerResult.Result.PENDING_MESSAGE_ID, xpMessage, errorText);
                if (this.dataFile.exists()) {
                    try {
                        this.tempFileCreator.deleteFile(this.dataFile);
                    }
                    catch (IOException e2) {
                        LOG.error("Could not delete data file. {}", (Object)e2.toString());
                    }
                } else {
                    LOG.debug("{} does not exist.", (Object)this.dataFile);
                }
                Agreements.clearThreadCache();
                Profiles.clearThreadCache();
                return sendToListenerResult;
            }
            try {
                try (BufferedOutputStream metaDataOutputStream = new BufferedOutputStream(Files.newOutputStream(new File(xpMessage.getCurrentContentReferenceFolder(), "xp_backendmessage.xml").toPath(), new OpenOption[0]));){
                    this.messageMetaData.store((OutputStream)metaDataOutputStream, null);
                }
                catch (IOException e) {
                    LOG.error("Cannot write to file for adapter meta data. {}", (Object)e.toString());
                }
                SendToListenerResult e = this.sendToListener.handleMessage(xpMessage);
                this.duplicateInProcessGuardian.endProcess(messageId);
                return e;
            }
            catch (MessageRecognitionException e) {
                SendToListenerResult sendToListenerResult;
                block33: {
                    block32: {
                        this.messageRegistrationService.logErrorAndSetFailedStatus(xpMessage, e.toString());
                        sendToListenerResult = new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_PROCESS_MESSAGE, xpMessage, e.getMessage());
                        this.duplicateInProcessGuardian.endProcess(messageId);
                        if (!this.dataFile.exists()) break block32;
                        try {
                            this.tempFileCreator.deleteFile(this.dataFile);
                        }
                        catch (IOException e3) {
                            LOG.error("Could not delete data file. {}", (Object)e3.toString());
                        }
                        break block33;
                    }
                    LOG.debug("{} does not exist.", (Object)this.dataFile);
                }
                Agreements.clearThreadCache();
                Profiles.clearThreadCache();
                return sendToListenerResult;
                {
                    catch (Throwable throwable) {
                        this.duplicateInProcessGuardian.endProcess(messageId);
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (this.dataFile.exists()) {
                try {
                    this.tempFileCreator.deleteFile(this.dataFile);
                }
                catch (IOException e) {
                    LOG.error("Could not delete data file. {}", (Object)e.toString());
                }
            } else {
                LOG.debug("{} does not exist.", (Object)this.dataFile);
            }
            Agreements.clearThreadCache();
            Profiles.clearThreadCache();
        }
    }

    private void sendStatusUpdate(SendToListenerResult sendToListenerResult, WebSocketConnection connection) {
        connection.sendStatusUpdate(sendToListenerResult);
    }

    private XpMessage convertSimplePropertiesToXpMessage(SimpleProperties messageMetaData) {
        XpMessage xpMessage = new XpMessage();
        xpMessage.setTransferId(messageMetaData.getProperty(AdapterPropertiesEnum.TRANSFER_ID));
        xpMessage.setMessageId(messageMetaData.getProperty(MetaDataPropertiesEnum.MESSAGE_ID));
        xpMessage.setConversationId(messageMetaData.getProperty(MetaDataPropertiesEnum.CONVERSATION_ID));
        if (messageMetaData.containsProperty(MetaDataPropertiesEnum.SEQUENCE_NUMBER)) {
            xpMessage.setSequenceNumber(Integer.parseInt(messageMetaData.getProperty(MetaDataPropertiesEnum.SEQUENCE_NUMBER)));
        }
        xpMessage.setReceiverInternalId(messageMetaData.getProperty(MetaDataPropertiesEnum.RECEIVER_ID));
        xpMessage.setSenderInternalId(messageMetaData.getProperty(MetaDataPropertiesEnum.SENDER_ID));
        if (messageMetaData.containsProperty(MetaDataPropertiesEnum.CREATION_TIME)) {
            String creationTimeAsString = messageMetaData.getProperty(MetaDataPropertiesEnum.CREATION_TIME);
            if (creationTimeAsString.length() > 10) {
                xpMessage.setMessageTimestamp(new Date(Long.parseLong(creationTimeAsString)));
            } else {
                xpMessage.setMessageTimestamp(new Date(Long.parseLong(creationTimeAsString + "000")));
            }
        } else {
            xpMessage.setMessageTimestamp(new Date());
        }
        xpMessage.setMessageType(messageMetaData.getProperty(MetaDataPropertiesEnum.MESSAGE_TYPE));
        xpMessage.setMessageVersion(messageMetaData.getProperty(MetaDataPropertiesEnum.MESSAGE_VERSION));
        xpMessage.setSchemaSet(messageMetaData.getProperty(MetaDataPropertiesEnum.SCHEMA_SET));
        Optional.ofNullable(messageMetaData.getProperty(MetaDataPropertiesEnum.MIME_TYPE)).ifPresentOrElse(xpMessage::setCurrentContentType, () -> {
            if (this.isContentXML()) {
                xpMessage.setCurrentContentType("text/xml");
            } else {
                xpMessage.setCurrentContentType(null);
            }
        });
        messageMetaData.getProperties(MetaDataPropertiesEnum.PROCESSING_DIRECTIVE).forEach(xpMessage::setProcessingDirective);
        Optional.ofNullable(messageMetaData.getProperty(MetaDataPropertiesEnum.LOG_INFO)).ifPresent(value -> xpMessage.setProcessingDirective("LogInfo", (String)value));
        Optional.ofNullable(messageMetaData.getProperty(MetaDataPropertiesEnum.FILENAME)).ifPresent(value -> xpMessage.setProcessingDirective("OriginalFilename", (String)value));
        Optional.ofNullable(xpMessage.getProcessingDirective("OriginalFilename")).ifPresent(value -> xpMessage.setProcessingDirective("ProcessedOriginalFilename", (String)value));
        return xpMessage;
    }

    private boolean isContentXML() {
        boolean bl;
        UTF8BOMSkippingInputStream inputStream = new UTF8BOMSkippingInputStream((InputStream)new BufferedInputStream(Files.newInputStream(this.dataFile.toPath(), new OpenOption[0])));
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            factory.setXMLReporter(null);
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader((InputStream)inputStream);
            xmlStreamReader.next();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return false;
            }
        }
        inputStream.close();
        return bl;
    }

    private boolean isRFC2822MessageId() {
        String value = this.messengerProperties.getProperty(PROPERTY_RFC2822_CONFORM_MESSAGE_ID, DEFAULT_RFC2822_CONFORM_MESSAGE_ID);
        return Boolean.parseBoolean(value);
    }
}

