/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket.messages;

import de.ponton.api.WebSocketAdapterInfo;
import de.ponton.api.websocket.ApiCloseCodes;
import de.ponton.api.websocket.OutboundMessageStatusUpdateFactory;
import de.ponton.api.websocket.messages.OutboundMessageWorker;
import de.ponton.api.websocket.messages.OutboundMessageWorkerFactory;
import de.ponton.xp.adapter.api.domainvalues.TransferId;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.StatusUpdateResponseEnum;
import de.ponton.xp.adapter.api.internal.WebSocketCloseCode;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolOutboundMessageResponse;
import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.MessageRegistrationService;
import de.pontonconsulting.xmlpipe.messenger.SendToListenerResult;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutboundMessageHandler {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.OutboundMessageHandler");
    private SimpleProperties properties;
    private Path dataFolder;
    private File dataFile;
    private OutputStream dataStream;
    private final TempFileCreator tempFileCreator;
    private final Executor executor;
    private final OutboundMessageWorkerFactory outboundMessageWorkerFactory;
    private final OutboundMessageStatusUpdateFactory outboundMessageStatusUpdateFactory;
    private TransferId transferId;
    private final MaintenanceManager maintenanceManager;
    private final ActivationControl activationControl;
    private final MessageRegistrationService messageRegistrationService;

    public OutboundMessageHandler(TempFileCreator tempFileCreator, Executor executor, OutboundMessageWorkerFactory outboundMessageWorkerFactory, OutboundMessageStatusUpdateFactory outboundMessageStatusUpdateFactory, MaintenanceManager maintenanceManager, ActivationControl activationControl, MessageRegistrationService messageRegistrationService) {
        this.tempFileCreator = tempFileCreator;
        this.executor = executor;
        this.outboundMessageWorkerFactory = outboundMessageWorkerFactory;
        this.outboundMessageStatusUpdateFactory = outboundMessageStatusUpdateFactory;
        this.maintenanceManager = maintenanceManager;
        this.activationControl = activationControl;
        this.messageRegistrationService = messageRegistrationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(byte[] partialMessage, boolean last, Session session, WebSocketAdapterInfo adapterInfo) {
        block12: {
            try {
                if (Objects.isNull(this.dataStream)) {
                    throw new IllegalStateException("OutboundMessageHandler is not initialized");
                }
                this.dataStream.write(partialMessage);
                if (!last) break block12;
                this.dataStream.close();
                LOG.debug("received {} bytes", (Object)this.dataFile.length());
                ProtocolOutboundMessageResponse.ProtocolOutboundMessageResponseBuilder responseBuilder = ProtocolOutboundMessageResponse.createBuilder().setTransferId(this.transferId);
                if (!this.activationControl.isActive()) {
                    LOG.error("Messenger license not activated. sending blocked.");
                    XpMessage tempMessage = this.messageRegistrationService.registerMessageFromAdapter(adapterInfo.getId());
                    this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger license not activated. sending blocked.");
                    Files.deleteIfExists(this.dataFile.toPath());
                    responseBuilder.setResult(StatusUpdateResponseEnum.REJECTED);
                    responseBuilder.setResultText("Messenger is not activated.");
                    session.getBasicRemote().sendText(responseBuilder.build().toWireFormat());
                    LOG.debug("sent OutboundMessageResponse 'RejectOutboundMSG' to adapter");
                    return;
                }
                if (this.maintenanceManager.isRejectOutboundMSGs()) {
                    LOG.error("Messenger is running in maintenance mode and blocks outbound messages.");
                    XpMessage tempMessage = this.messageRegistrationService.registerMessageFromAdapter(adapterInfo.getId());
                    this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger is in maintenance mode. sending blocked.");
                    Files.deleteIfExists(this.dataFile.toPath());
                    responseBuilder.setResult(StatusUpdateResponseEnum.REJECTED);
                    responseBuilder.setResultText(MessageResult.MAINTENANCE_MODE.getDescription());
                    session.getBasicRemote().sendText(responseBuilder.build().toWireFormat());
                    LOG.debug("sent OutboundMessageResponse 'RejectOutboundMSG' to adapter");
                    return;
                }
                OutboundMessageWorker outboundMessageWorker = this.outboundMessageWorkerFactory.createInstance(this.dataFile, this.properties, adapterInfo);
                if (ProtocolMessageTypeEnum.SyncOutboundMessage.toString().equals(this.properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE))) {
                    SendToListenerResult sendToListenerResult = outboundMessageWorker.processOutboundMessage();
                    SimpleProperties statusUpdate = this.outboundMessageStatusUpdateFactory.createStatusUpdate(sendToListenerResult);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    statusUpdate.store((OutputStream)outputStream, null);
                    session.getBasicRemote().sendText(outputStream.toString(StandardCharsets.UTF_8));
                    LOG.debug("sent OutboundMessageStatusResponse for SyncOutboundMessage to adapter");
                    return;
                }
                try {
                    this.executor.execute(outboundMessageWorker);
                    responseBuilder.setResult(StatusUpdateResponseEnum.SUCCESS);
                }
                catch (RejectedExecutionException e) {
                    XpMessage tempMessage = this.messageRegistrationService.registerMessageFromAdapter(adapterInfo.getId());
                    this.messageRegistrationService.logErrorAndSetFailedStatus(tempMessage, "Messenger is too busy. sending blocked.");
                    responseBuilder.setResult(StatusUpdateResponseEnum.REJECTED);
                    responseBuilder.setResultText(e.getMessage());
                }
                finally {
                    session.getBasicRemote().sendText(responseBuilder.build().toWireFormat());
                    LOG.debug("sent OutboundMessageResponse to adapter");
                    outboundMessageWorker.startExecution();
                }
            }
            catch (IOException e) {
                LOG.error("could not write to temp file or could not send response to remote {}: {}", (Object)this.dataFile, (Object)e);
                this.closeSession(session, "could not write to temp file", WebSocketCloseCode.INTERNAL_ERROR);
            }
            catch (IllegalStateException e) {
                LOG.error("OutboundMessageHandler is not initialized.", (Throwable)e);
                this.closeSession(session, "OutboundMessageHandler is not initialized", WebSocketCloseCode.PROTOCOL_ERROR);
            }
        }
    }

    public void initializeHandler(SimpleProperties properties, Session session) {
        this.properties = properties;
        try {
            String transferIdValue = properties.getProperty(AdapterPropertiesEnum.TRANSFER_ID);
            this.transferId = new TransferId(transferIdValue);
            LOG.debug("receiving message with {}", (Object)this.transferId);
            this.dataFolder = this.tempFileCreator.createTempFolder("api-" + this.transferId.getStringValue());
            this.dataFile = this.tempFileCreator.createTempFile("payload-" + transferIdValue, ".raw", this.dataFolder);
            this.dataStream = new BufferedOutputStream(Files.newOutputStream(this.dataFile.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            LOG.error("could not create temp file {}: {}", (Object)this.dataFile, (Object)e);
            this.closeSession(session, "could not create temp file", WebSocketCloseCode.INTERNAL_ERROR);
        }
    }

    private void closeSession(Session session, String reason, WebSocketCloseCode webSocketCloseCode) {
        try {
            session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(webSocketCloseCode), reason));
        }
        catch (IOException ex) {
            LOG.error("could not close session.", (Throwable)ex);
        }
    }

    public void onClose() {
        try {
            if (this.dataStream != null) {
                this.dataStream.close();
            }
            this.tempFileCreator.deleteDirectory(this.dataFolder);
        }
        catch (IOException e) {
            LOG.error("could not purge temp data directory {}: {}", (Object)this.dataFolder, (Object)e);
        }
    }
}

