/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket.messages;

import de.ponton.api.AdapterGateway;
import de.ponton.api.WebSocketAdapterInfo;
import de.ponton.api.websocket.AbstractEndpoint;
import de.ponton.api.websocket.ApiCloseCodes;
import de.ponton.api.websocket.ErrorNotificationFactory;
import de.ponton.api.websocket.MessageDigestFactory;
import de.ponton.api.websocket.OutboundMessageStatusUpdateFactory;
import de.ponton.api.websocket.WebSocketConnection;
import de.ponton.api.websocket.security.SignatureVerifier;
import de.ponton.xp.adapter.api.domainvalues.AdapterApiVersion;
import de.ponton.xp.adapter.api.domainvalues.ApiMetaData;
import de.ponton.xp.adapter.api.domainvalues.MessengerName;
import de.ponton.xp.adapter.api.domainvalues.MessengerVersion;
import de.ponton.xp.adapter.api.domainvalues.internal.AdapterApiVersionImpl;
import de.ponton.xp.adapter.api.domainvalues.internal.ApiMetaDataImpl;
import de.ponton.xp.adapter.api.domainvalues.internal.MessengerNameImpl;
import de.ponton.xp.adapter.api.domainvalues.internal.MessengerVersionImpl;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.WebSocketCloseCode;
import de.ponton.xp.adapter.api.internal.messages.ProtocolRegisterSuccessMessage;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChallengeResponseHandler {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ChallengeResponseHandler");
    private final OutboundMessageStatusUpdateFactory outboundMessageStatusUpdateFactory;
    private final ErrorNotificationFactory errorNotificationFactory;
    private final AdapterGateway adapterGateway;
    private final SignatureVerifier signatureVerifier;
    private final MessageDigestFactory messageDigestFactory;
    private final IServerConfigBean serverConfig;

    public ChallengeResponseHandler(OutboundMessageStatusUpdateFactory outboundMessageStatusUpdateFactory, ErrorNotificationFactory errorNotificationFactory, AdapterGateway adapterGateway, SignatureVerifier signatureVerifier, MessageDigestFactory messageDigestFactory, IServerConfigBean serverConfig) {
        this.outboundMessageStatusUpdateFactory = outboundMessageStatusUpdateFactory;
        this.errorNotificationFactory = errorNotificationFactory;
        this.adapterGateway = Objects.requireNonNull(adapterGateway, "adapterGateway cannot be null");
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier, "signatureVerifier cannot be null");
        this.messageDigestFactory = Objects.requireNonNull(messageDigestFactory, "messageDigestFactory cannot be null");
        this.serverConfig = Objects.requireNonNull(serverConfig, "serverConfig cannot be null");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public WebSocketAdapterInfo handleMessage(byte[] partialMessage, byte[] challengeBytes, Session session, AbstractEndpoint endpoint) throws AdapterException, IOException, GeneralSecurityException {
        LOG.trace("processing challenge response message");
        try (ByteArrayInputStream dataStream = new ByteArrayInputStream(partialMessage);){
            WebSocketAdapterInfo webSocketAdapterInfo;
            try (DataInputStream dataInputStream = new DataInputStream(dataStream);){
                short signatureLength = dataInputStream.readShort();
                byte[] signature = new byte[signatureLength];
                dataInputStream.readFully(signature);
                short publicKeyLength = dataInputStream.readShort();
                byte[] publicKey = new byte[publicKeyLength];
                dataInputStream.readFully(publicKey);
                boolean validSignature = this.signatureVerifier.verify(challengeBytes, signature, publicKey);
                if (!validSignature) {
                    throw new GeneralSecurityException("signature is invalid");
                }
                SimpleProperties properties = new SimpleProperties();
                properties.load((InputStream)dataInputStream);
                String apiMessageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE, "UNKNOWN");
                if (!"ChallengeResponseMessage".equals(apiMessageType)) {
                    throw new AdapterException("unexpected message type " + apiMessageType);
                }
                String adapterId = properties.getProperty(AdapterPropertiesEnum.ADAPTER_ID);
                String adapterVersion = properties.getProperty(AdapterPropertiesEnum.ADAPTER_VERSION);
                String adapterApiVersion = properties.getProperty(AdapterPropertiesEnum.API_VERSION);
                String instanceId = this.calculateInstanceId(publicKey);
                int processingTimeout = Integer.parseInt(properties.getProperty(AdapterPropertiesEnum.ADAPTER_PROCESSING_TIMEOUT, String.valueOf(this.serverConfig.getAdapterInterfaceTimeout())));
                boolean adapterSupportsStatusUpdate = Boolean.parseBoolean(properties.getProperty(AdapterPropertiesEnum.ADAPTER_SUPPORTS_STATUS_UPDATE, "true"));
                boolean adapterSupportsErrorNotification = Boolean.parseBoolean(properties.getProperty(AdapterPropertiesEnum.ADAPTER_SUPPORTS_ERROR_NOTIFICATION, "false"));
                boolean adapterSupportsInboundMessage = Boolean.parseBoolean(properties.getProperty(AdapterPropertiesEnum.ADAPTER_SUPPORTS_INBOUND_MESSAGE, "true"));
                boolean adapterSupportsArchive = Boolean.parseBoolean(properties.getProperty(AdapterPropertiesEnum.ADAPTER_SUPPORTS_ARCHIVE, "false"));
                WebSocketConnection webSocketConnection = new WebSocketConnection(this.outboundMessageStatusUpdateFactory, this.errorNotificationFactory, session, endpoint, processingTimeout);
                WebSocketAdapterInfo adapterInfo = this.adapterGateway.registerAdapterSession(adapterId, instanceId, webSocketConnection, adapterSupportsStatusUpdate, adapterSupportsErrorNotification, adapterSupportsInboundMessage, adapterSupportsArchive);
                LOG.info("successfully registered adapter {}, version {}, instanceId {}, apiVersion {}", (Object)adapterId, (Object)adapterVersion, (Object)instanceId, (Object)adapterApiVersion);
                ApiMetaDataImpl apiMetaData = ApiMetaDataImpl.newBuilder().setAdapterApiVersion((AdapterApiVersion)new AdapterApiVersionImpl("2.0.0")).setMessengerName((MessengerName)new MessengerNameImpl("myMessenger")).setMessengerVersion((MessengerVersion)new MessengerVersionImpl(Constants.getXP_VERSION())).build();
                ProtocolRegisterSuccessMessage registerSuccessMessage = ProtocolRegisterSuccessMessage.createBuilder().setApiMetaData((ApiMetaData)apiMetaData).build();
                session.getBasicRemote().sendBinary(ByteBuffer.wrap(registerSuccessMessage.toWireFormat().getBytes(StandardCharsets.UTF_8)));
                LOG.trace("sent register success message to adapter");
                webSocketAdapterInfo = adapterInfo;
            }
            return webSocketAdapterInfo;
        }
        catch (AdapterException e) {
            session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(WebSocketCloseCode.PROTOCOL_ERROR), e.toString()));
            throw e;
        }
        catch (IOException e) {
            session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(WebSocketCloseCode.INTERNAL_ERROR), e.toString()));
            throw e;
        }
        catch (GeneralSecurityException e) {
            session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(WebSocketCloseCode.AUTHENTICATION_FAILED), e.toString()));
            throw e;
        }
    }

    private String calculateInstanceId(byte[] publicKey) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = this.messageDigestFactory.createMD5MessageDigest();
        byte[] hash = messageDigest.digest(publicKey);
        return "wss://hash/" + Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
    }
}

