/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.api.websocket.AbstractEndpoint;
import de.ponton.api.websocket.ApiArchiveEndpoint;
import de.ponton.api.websocket.ApiInboundEndpoint;
import de.ponton.api.websocket.ErrorNotificationFactory;
import de.ponton.api.websocket.OutboundMessageStatusUpdateFactory;
import de.ponton.xp.adapter.api.domainvalues.InboundStatusEnum;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.StatusUpdateResponseEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.messenger.SendToListenerResult;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpOutboundMessage;
import jakarta.websocket.Session;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebSocketConnection {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.WebSocketConnection");
    private static final String UNKNOWN = "UNKNOWN";
    private final OutboundMessageStatusUpdateFactory outboundMessageStatusUpdateFactory;
    private final ErrorNotificationFactory errorNotificationFactory;
    private final Session session;
    private final AbstractEndpoint endpoint;
    private final int timeout;

    public WebSocketConnection(OutboundMessageStatusUpdateFactory outboundMessageStatusUpdateFactory, ErrorNotificationFactory errorNotificationFactory, Session session, AbstractEndpoint endpoint, int timeout) {
        this.outboundMessageStatusUpdateFactory = outboundMessageStatusUpdateFactory;
        this.errorNotificationFactory = errorNotificationFactory;
        this.endpoint = endpoint;
        this.session = session;
        this.timeout = timeout;
    }

    public boolean isInboundConnection() {
        return this.endpoint instanceof ApiInboundEndpoint;
    }

    public boolean isArchiveConnection() {
        return this.endpoint instanceof ApiArchiveEndpoint;
    }

    public Session getSession() {
        return this.session;
    }

    public AbstractEndpoint getEndpoint() {
        return this.endpoint;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public SimpleProperties send(SimpleProperties requestHeader, Optional<InputStream> requestBody) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        CompletableFuture<SimpleProperties> response = this.endpoint.expectResponse();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        requestHeader.store((OutputStream)outputStream, "Messenger " + Constants.getXP_VERSION());
        this.session.getBasicRemote().sendText(outputStream.toString());
        LOG.trace("metadata transmitted");
        if (requestBody.isPresent()) {
            int len;
            InputStream inputStream = requestBody.get();
            byte[] buffer = new byte[8192];
            long total = 0L;
            while ((len = inputStream.read(buffer)) > 0) {
                this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(buffer, 0, len), false);
                total += (long)len;
            }
            this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(new byte[0]), true);
            LOG.trace("{} bytes of data transmitted", (Object)total);
        }
        return response.get(this.timeout, TimeUnit.SECONDS);
    }

    public SimpleProperties receive(SimpleProperties requestHeader, Supplier<OutputStream> supplier) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        CompletableFuture<SimpleProperties> response = this.endpoint.expectResponse(supplier);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        requestHeader.store((OutputStream)outputStream, "Messenger " + Constants.getXP_VERSION());
        this.session.getBasicRemote().sendText(outputStream.toString());
        LOG.trace("metadata transmitted");
        return response.get(this.timeout, TimeUnit.SECONDS);
    }

    public MessageResult sendInboundMessage(XpInboundMessage xpInboundMessage) throws InterruptedException {
        MessageResult result;
        Object statusText;
        LOG.debug("[{}] starting delivery inbound xpInboundQueueMessage to adapter {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId());
        SimpleProperties properties = this.convertToInboundMessage(xpInboundMessage);
        CompletableFuture<SimpleProperties> response = this.endpoint.expectResponse();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            properties.store((OutputStream)outputStream, "Messenger " + Constants.getXP_VERSION());
            this.session.getBasicRemote().sendText(outputStream.toString(StandardCharsets.UTF_8));
            LOG.trace("[{}] metadata transmitted", (Object)xpInboundMessage.getDatabaseId());
            try {
                this.transmitInboundMessageContent(xpInboundMessage, properties);
            }
            catch (NullPointerException e) {
                String statusText2 = e.toString();
                LOG.error("[{}] NullPointerException while sending to Adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), (Object)statusText2);
                MessageResult result2 = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
                result2.appendToDescription("Payload file not found.");
                return result2;
            }
            SimpleProperties responseProperties = response.get(this.timeout, TimeUnit.SECONDS);
            String status = responseProperties.getProperty(AdapterPropertiesEnum.STATUS);
            LOG.trace("[{}] adapter result {}", (Object)xpInboundMessage.getDatabaseId(), (Object)status);
            InboundStatusEnum statusEnum = InboundStatusEnum.valueOf((String)status);
            statusText = responseProperties.getProperty(AdapterPropertiesEnum.STATUS_TEXT);
            switch (statusEnum) {
                case SUCCESS: {
                    result = new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
                    break;
                }
                case REJECTED: {
                    result = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
                    break;
                }
                default: {
                    result = new MessageResult(MessageResult.CUSTOM_ERROR);
                    break;
                }
            }
        }
        catch (IOException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = e.toString();
            LOG.error("[{}] IOException while sending to Adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        catch (ExecutionException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = e.getCause().toString();
            LOG.error("[{}] Exception while sending to Adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        catch (TimeoutException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = "no response received within " + this.timeout + " seconds";
            LOG.error("[{}] Timeout while sending to Adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        result.appendToDescription((String)statusText);
        return result;
    }

    private void transmitInboundMessageContent(XpInboundMessage xpInboundMessage, SimpleProperties properties) throws IOException {
        File dataFile = xpInboundMessage.getCurrentContentReference();
        File metaDataFile = new File(dataFile.getParentFile(), "xp_backendmessage.xml");
        try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(metaDataFile.toPath(), new OpenOption[0]));){
            properties.store((OutputStream)fileOutputStream, "Messenger " + Constants.getXP_VERSION());
        }
        try (InputStream fileInputStream = Files.newInputStream(dataFile.toPath(), new OpenOption[0]);){
            int len;
            byte[] buffer = new byte[8192];
            long total = 0L;
            while ((len = fileInputStream.read(buffer)) > 0) {
                this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(buffer, 0, len), false);
                total += (long)len;
            }
            this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(new byte[0]), true);
            LOG.trace("[{}] {} bytes of data transmitted", (Object)xpInboundMessage.getDatabaseId(), (Object)total);
        }
    }

    private SimpleProperties convertToInboundMessage(XpInboundMessage xpQueueMessage) {
        SimpleProperties properties = new SimpleProperties();
        properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.InboundMessage.name());
        properties.setProperty(AdapterPropertiesEnum.CONTENT_LENGTH, String.valueOf(xpQueueMessage.getCurrentContentReference().length()));
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_UNIQUE_ID, String.valueOf(xpQueueMessage.getDatabaseId()));
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_ID, xpQueueMessage.getMessageId());
        properties.setProperty(MetaDataPropertiesEnum.CONVERSATION_ID, xpQueueMessage.getConversationId());
        properties.setProperty(MetaDataPropertiesEnum.SEQUENCE_NUMBER, String.valueOf(xpQueueMessage.getSequenceNumber()));
        properties.setProperty(MetaDataPropertiesEnum.SENDER_ID, xpQueueMessage.getSenderInternalId());
        properties.setProperty(MetaDataPropertiesEnum.RECEIVER_ID, xpQueueMessage.getReceiverInternalId());
        properties.setProperty(MetaDataPropertiesEnum.CREATION_TIME, String.valueOf(xpQueueMessage.getMessageTimestamp().getTime()));
        properties.setProperty(MetaDataPropertiesEnum.RECEPTION_TIME, String.valueOf(xpQueueMessage.getRegistrationTimestamp() != null ? xpQueueMessage.getRegistrationTimestamp().getTime() : xpQueueMessage.getMessageTimestamp().getTime()));
        String originalFileName = xpQueueMessage.getProcessingDirective("OriginalFilename");
        if (originalFileName != null) {
            properties.setProperty(MetaDataPropertiesEnum.FILENAME, originalFileName);
        } else {
            properties.setProperty(MetaDataPropertiesEnum.FILENAME, xpQueueMessage.getProcessingDirective("ProcessedOriginalFilename"));
        }
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_TYPE, xpQueueMessage.getMessageType());
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_TYPE_DISPLAY_NAME, xpQueueMessage.getMessageType());
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_VERSION, xpQueueMessage.getMessageVersion());
        properties.setProperty(MetaDataPropertiesEnum.SCHEMA_SET, xpQueueMessage.getSchemaSet());
        properties.setProperty(MetaDataPropertiesEnum.MIME_TYPE, xpQueueMessage.getCurrentContentType());
        properties.setProperty(MetaDataPropertiesEnum.LOG_INFO, xpQueueMessage.getProcessingDirective("LogInfo"), UNKNOWN);
        String duplicatedProcessingDirectives = "LogInfo|OriginalFilename";
        Map<String, String> processingDirectives = xpQueueMessage.getProcessingDirectives().entrySet().stream().filter(procDir -> !((String)procDir.getKey()).matches("LogInfo|OriginalFilename")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        properties.setProperties(MetaDataPropertiesEnum.PROCESSING_DIRECTIVE, processingDirectives);
        return properties;
    }

    public MessageResult sendFinalStatusUpdate(XpInboundMessage xpInboundMessage) {
        MessageResult result;
        Object statusText;
        LOG.debug("[{}] starting delivery status update with transferId {} to adapter {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getTransferId(), (Object)xpInboundMessage.getAdapterId());
        try {
            SimpleProperties responseProperties = this.sendStatusUpdate(this.outboundMessageStatusUpdateFactory.createStatusUpdate(xpInboundMessage), xpInboundMessage.getDatabaseId());
            String status = responseProperties.getProperty(AdapterPropertiesEnum.RESULT);
            StatusUpdateResponseEnum statusEnum = StatusUpdateResponseEnum.valueOf((String)status);
            statusText = responseProperties.getProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT);
            switch (statusEnum) {
                case SUCCESS: {
                    result = new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
                    break;
                }
                case REJECTED: {
                    result = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
                    break;
                }
                default: {
                    result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
                    break;
                }
            }
        }
        catch (IOException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = e.toString();
            LOG.error("[{}] IOException while sending to adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        catch (ExecutionException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = e.getCause().toString();
            LOG.error("[{}] Exception while sending to adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = "delivery to adapter was interrupted";
            LOG.error("[{}] delivery to adapter {} was interrupted", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId());
        }
        catch (TimeoutException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = "no response received within " + this.timeout + " seconds";
            LOG.error("[{}] Timeout while sending to Adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        result.setDescription((String)statusText);
        return result;
    }

    public MessageResult sendErrorNotification(XpInboundMessage xpInboundMessage) {
        MessageResult result;
        Object statusText;
        LOG.debug("[{}] starting delivery error notification with transferId {} to adapter {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getTransferId(), (Object)xpInboundMessage.getAdapterId());
        try {
            SimpleProperties responseProperties = this.sendErrorNotificationToAdapter(this.errorNotificationFactory.createErrorNotification(xpInboundMessage), xpInboundMessage);
            String status = responseProperties.getProperty(AdapterPropertiesEnum.RESULT);
            StatusUpdateResponseEnum statusEnum = StatusUpdateResponseEnum.valueOf((String)status);
            statusText = responseProperties.getProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT);
            switch (statusEnum) {
                case SUCCESS: {
                    result = new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
                    break;
                }
                case REJECTED: {
                    result = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
                    break;
                }
                default: {
                    result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
                    break;
                }
            }
        }
        catch (IOException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = e.toString();
            LOG.error("[{}] IOException while sending to adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        catch (ExecutionException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = e.getCause().toString();
            LOG.error("[{}] Exception while sending to adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = "delivery to adapter was interrupted";
            LOG.error("[{}] delivery to adapter {} was interrupted", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId());
        }
        catch (TimeoutException e) {
            result = new MessageResult(MessageResult.COULD_NOT_PROCESS_MESSAGE);
            statusText = "no response received within " + this.timeout + " seconds";
            LOG.error("[{}] Timeout while sending to Adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), statusText);
        }
        result.setDescription((String)statusText);
        return result;
    }

    public String requestAdapterStatusUpdate() {
        String string;
        CompletableFuture<SimpleProperties> response = this.endpoint.expectResponse();
        SimpleProperties statusUpdate = new SimpleProperties();
        statusUpdate.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.AdapterStatusRequest.name());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            statusUpdate.store((OutputStream)outputStream, "Messenger " + Constants.getXP_VERSION());
            this.session.getBasicRemote().sendText(outputStream.toString(StandardCharsets.UTF_8));
            string = response.get(this.timeout, TimeUnit.SECONDS).getProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.error("Could not get Status Response from Adapter message: {}", (Object)e.toString());
                return e.getMessage();
            }
        }
        outputStream.close();
        return string;
    }

    private SimpleProperties sendStatusUpdate(SimpleProperties statusUpdate, long databaseId) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        CompletableFuture<SimpleProperties> response = this.endpoint.expectResponse();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            statusUpdate.store((OutputStream)outputStream, "Messenger " + Constants.getXP_VERSION());
            this.session.getBasicRemote().sendText(outputStream.toString(StandardCharsets.UTF_8));
            LOG.trace("[{}] status update transmitted", (Object)databaseId);
            SimpleProperties simpleProperties = response.get(this.timeout, TimeUnit.SECONDS);
            return simpleProperties;
        }
    }

    private SimpleProperties sendErrorNotificationToAdapter(SimpleProperties errorNotification, XpInboundMessage xpInboundMessage) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        CompletableFuture<SimpleProperties> response = this.endpoint.expectResponse();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            errorNotification.store((OutputStream)outputStream, "Messenger " + Constants.getXP_VERSION());
            this.session.getBasicRemote().sendText(outputStream.toString(StandardCharsets.UTF_8));
            LOG.trace("[{}] error notification transmitted", (Object)xpInboundMessage.getDatabaseId());
            SimpleProperties simpleProperties = response.get(this.timeout, TimeUnit.SECONDS);
            return simpleProperties;
        }
    }

    public void sendStatusUpdate(SendToListenerResult sendToListenerResult) {
        XpOutboundMessage xpMessage = sendToListenerResult.getXpOutboundQueueMessage();
        try {
            SimpleProperties responseProperties = this.sendStatusUpdate(this.outboundMessageStatusUpdateFactory.createStatusUpdate(sendToListenerResult), xpMessage.getDatabaseId());
            String status = responseProperties.getProperty(AdapterPropertiesEnum.RESULT);
            String statusText = responseProperties.getProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT);
            LOG.debug("[{}] received sync response for a status update from adapter {} with status {} and message {}", (Object)xpMessage.getDatabaseId(), (Object)xpMessage.getAdapterId(), (Object)status, (Object)statusText);
        }
        catch (IOException | ExecutionException e) {
            LOG.error("[{}] Exception while sending a status update to adapter {}: {}", (Object)xpMessage.getDatabaseId(), (Object)xpMessage.getAdapterId(), (Object)e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("[{}] delivery of a status update to adapter {} was interrupted", (Object)xpMessage.getDatabaseId(), (Object)xpMessage.getAdapterId());
        }
        catch (TimeoutException e) {
            String statusText = "no response received within " + this.timeout + " seconds";
            LOG.error("[{}] Timeout while sending to Adapter {}: {}", (Object)xpMessage.getDatabaseId(), (Object)xpMessage.getAdapterId(), (Object)statusText);
        }
    }
}

