/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.api.WebSocketAdapterInfo;
import de.ponton.api.websocket.ApiCloseCodes;
import de.ponton.api.websocket.ChallengeMessage;
import de.ponton.api.websocket.messages.ChallengeResponseHandler;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.WebSocketCloseCode;
import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.websocket.core.exception.WebSocketTimeoutException;

public abstract class AbstractEndpoint
extends Endpoint
implements MessageHandler.Partial<byte[]> {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.AbstractEndpoint");
    private final ChallengeResponseHandler challengeResponseHandler;
    protected Session session = null;
    protected WebSocketAdapterInfo adapterInfo;
    private byte[] challengeBytes;
    protected boolean authenticated;
    protected SimpleProperties responseHeader;
    protected Supplier<OutputStream> supplier;
    protected CompletableFuture<SimpleProperties> expectResponse;

    public AbstractEndpoint(ChallengeResponseHandler challengeResponseHandler) {
        this.challengeResponseHandler = challengeResponseHandler;
    }

    public void onOpen(Session session, EndpointConfig config) {
        LOG.debug("onOpen(): session: {}, config {}", (Object)session, (Object)config);
        session.addMessageHandler((MessageHandler)this);
        this.session = session;
        try {
            ChallengeMessage challengeMessage = new ChallengeMessage();
            this.challengeBytes = challengeMessage.getChallenge();
            session.getBasicRemote().sendBinary(ByteBuffer.wrap(this.challengeBytes), true);
        }
        catch (IOException e) {
            LOG.error("could not send challenge on open. {}", (Object)e.getMessage());
        }
    }

    public void onMessage(byte[] partialMessage, boolean last) {
        if (!this.authenticated) {
            try {
                this.adapterInfo = this.challengeResponseHandler.handleMessage(partialMessage, this.challengeBytes, this.session, this);
                this.authenticated = true;
            }
            catch (AdapterException | IOException | GeneralSecurityException e) {
                LOG.error("could not register adapter. {}", (Object)e.toString());
            }
        }
    }

    protected void closeUnauthenticatedSession() {
        LOG.error("session not authenticated. closing session.");
        try {
            this.session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(WebSocketCloseCode.PROTOCOL_ERROR), "not authenticated"));
        }
        catch (IOException e) {
            LOG.error("could not close session. {}", (Object)e.toString());
        }
    }

    protected void closeSessionWithProtocolError(String reason) {
        LOG.error("protocol error: {}. closing session.", (Object)reason);
        try {
            this.session.close(new CloseReason((CloseReason.CloseCode)new ApiCloseCodes(WebSocketCloseCode.PROTOCOL_ERROR), reason));
        }
        catch (IOException e) {
            LOG.error("could not close session. {}", (Object)e.getMessage());
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (this.adapterInfo != null) {
            LOG.info("onClose for adapter {} session: {}, closeReason {}", (Object)this.adapterInfo.getId(), (Object)session, (Object)closeReason);
            this.adapterInfo.removeSession(session);
        } else {
            LOG.info("onClose session: {}, closeReason {}", (Object)session, (Object)closeReason);
        }
        super.onClose(session, closeReason);
    }

    public void onError(Session session, Throwable thr) {
        String adapterIdText;
        String string = adapterIdText = this.adapterInfo == null ? "" : " for adapter " + this.adapterInfo.getId();
        if (thr instanceof WebSocketTimeoutException) {
            LOG.trace("onError{} error: {}, session: {}", (Object)adapterIdText, (Object)thr, (Object)session);
        } else {
            LOG.error("onError{} error: {}, session: {}", (Object)adapterIdText, (Object)thr, (Object)session);
        }
        super.onError(session, thr);
    }

    public SimpleProperties convert(String message) {
        SimpleProperties properties = new SimpleProperties();
        properties.load(message);
        return properties;
    }

    public CompletableFuture<SimpleProperties> expectResponse() {
        return this.expectResponse(null);
    }

    public CompletableFuture<SimpleProperties> expectResponse(Supplier<OutputStream> supplier) {
        this.supplier = supplier;
        this.responseHeader = null;
        this.expectResponse = new CompletableFuture();
        return this.expectResponse;
    }
}

