/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.applicationpart.patchinfo;

import de.ponton.application.update.api.wrapperconf.OsType;
import de.ponton.application.update.applicationpart.exception.PatchException;
import de.ponton.application.update.applicationpart.patchinfo.Version;
import java.io.File;
import java.util.Objects;

public class PatchInfo
implements Comparable<PatchInfo> {
    private final File patchFile;
    private final Version minAppVersion;
    private final Version postPatchAppVersion;
    private final Version postPatchAppJavaVersion;
    private final Version minPatcherJavaVersion;
    private final OsType osType;
    private final String appID;
    private final String addonID;
    private final Version minAppJavaVersion;
    private final String newJavaPath;
    private final Version postPatchAddonVersion;
    private final Version addonApiVersion;
    private final Version addonConfigVersion;
    private final long requiredDiskSpace;

    PatchInfo(File patchFile, Version minAppVersion, Version postPatchAppVersion, Version postPatchAppJavaVersion, Version minPatcherJavaVersion, long requiredDiskSpace, OsType osType, String appID, String addonID, Version minAppJavaVersion, String newJavaPath, Version postPatchAddonVersion, Version addonApiVersion, Version addonConfigVersion) throws PatchException {
        this.patchFile = Objects.requireNonNull(patchFile, "Patch requires a real patch file.");
        this.requiredDiskSpace = requiredDiskSpace;
        this.minAppVersion = Objects.requireNonNull(minAppVersion, "Patch requires a minimal application version.");
        this.postPatchAppVersion = postPatchAppVersion;
        this.postPatchAppJavaVersion = postPatchAppJavaVersion;
        this.minPatcherJavaVersion = Objects.requireNonNull(minPatcherJavaVersion, "Patch requires a minimal java version.");
        this.osType = Objects.requireNonNull(osType, "Patch requires an os type.");
        this.appID = Objects.requireNonNull(appID, "Patch requires its Application ID.");
        this.minAppJavaVersion = minAppJavaVersion;
        this.newJavaPath = newJavaPath;
        this.addonID = addonID;
        this.postPatchAddonVersion = postPatchAddonVersion;
        this.addonApiVersion = addonApiVersion;
        this.addonConfigVersion = addonConfigVersion;
        if (this.requiredDiskSpace <= 0L) {
            throw new PatchException("required disk space must be greater than 0");
        }
    }

    public File getPatchFile() {
        return this.patchFile;
    }

    public Version getMinAppVersion() {
        return this.minAppVersion;
    }

    public Version getPostPatchAppVersion() {
        return this.postPatchAppVersion;
    }

    public Version getPostPatchAppJavaVersion() {
        return this.postPatchAppJavaVersion;
    }

    public Version getMinPatcherJavaVersion() {
        return this.minPatcherJavaVersion;
    }

    public OsType getOsType() {
        return this.osType;
    }

    public long getRequiredDiskSpace() {
        return this.requiredDiskSpace;
    }

    public String getAppID() {
        return this.appID;
    }

    public String getAddonID() {
        return this.addonID;
    }

    public Version getMinAppJavaVersion() {
        return this.minAppJavaVersion;
    }

    public String getNewJavaPath() {
        return this.newJavaPath;
    }

    public Version getPostPatchAddonVersion() {
        return this.postPatchAddonVersion;
    }

    public Version getAddonApiVersion() {
        return this.addonApiVersion;
    }

    public Version getAddonConfigVersion() {
        return this.addonConfigVersion;
    }

    public int hashCode() {
        return Objects.hash(this.patchFile, this.minAppVersion, this.postPatchAppVersion, this.minPatcherJavaVersion, this.postPatchAppJavaVersion, this.appID);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PatchInfo)) {
            return false;
        }
        PatchInfo that = (PatchInfo)other;
        return Objects.equals(this.patchFile, that.patchFile) && Objects.equals(this.minAppVersion, that.minAppVersion) && Objects.equals(this.postPatchAppVersion, that.postPatchAppVersion) && Objects.equals(this.postPatchAppJavaVersion, that.postPatchAppJavaVersion) && Objects.equals(this.minPatcherJavaVersion, that.minPatcherJavaVersion) && Objects.equals((Object)this.osType, (Object)that.osType) && Objects.equals(this.appID, that.appID);
    }

    @Override
    public int compareTo(PatchInfo other) {
        int compareResult = this.minAppVersion.compareTo(other.minAppVersion);
        if (compareResult == 0 && (compareResult = this.postPatchAppJavaVersion.compareTo(other.postPatchAppJavaVersion)) == 0 && (compareResult = this.postPatchAppVersion.compareTo(other.postPatchAppVersion)) == 0) {
            compareResult = this.minPatcherJavaVersion.compareTo(other.minPatcherJavaVersion);
        }
        return compareResult;
    }

    public String toString() {
        return "PatchInfo{patchFile=" + this.patchFile + ", minAppVersion=" + this.minAppVersion + ", postPatchAppVersion=" + this.postPatchAppVersion + ", postPatchAppJavaVersion=" + this.postPatchAppJavaVersion + ", minPatcherJavaVersion=" + this.minPatcherJavaVersion + ", osType=" + (Object)((Object)this.osType) + ", appID=" + this.appID + ", addonID=" + this.addonID + ", minAppJavaVersion=" + this.minAppJavaVersion + ", newJavaPath='" + this.newJavaPath + '\'' + ", afterAddonPatchVersion=" + this.postPatchAddonVersion + ", addonApiVersion=" + this.addonApiVersion + ", addonConfigVersion=" + this.addonConfigVersion + ", requiredDiskSpace=" + this.requiredDiskSpace + '}';
    }
}

