/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.applicationpart.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class DeleteFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path mainPath;

    public DeleteFileVisitor(Path mainPath) {
        this.mainPath = mainPath;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
        Files.delete(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path directory, IOException exception) throws IOException {
        if (exception == null) {
            if (!directory.equals(this.mainPath)) {
                Files.delete(directory);
            }
            return FileVisitResult.CONTINUE;
        }
        throw exception;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.TERMINATE;
    }
}

