/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal.messages;

import de.ponton.xp.adapter.api.domainvalues.MessageType;
import de.ponton.xp.adapter.api.domainvalues.OutboundMetaData;
import de.ponton.xp.adapter.api.domainvalues.ProcessingDirective;
import de.ponton.xp.adapter.api.domainvalues.SerializeableDomainValue;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessage;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.messages.OutboundMessage;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import java.util.TreeMap;

public class ProtocolOutboundMessage
extends ProtocolMessage {
    static final SecureRandom secureRandom;

    public static ProtocolOutboundMessageBuilder createBuilder() {
        return new ProtocolOutboundMessageBuilder();
    }

    private ProtocolOutboundMessage(OutboundMessage outboundMessage, boolean syncReply) {
        super(syncReply ? ProtocolMessageTypeEnum.SyncOutboundMessage : ProtocolMessageTypeEnum.OutboundMessage);
        Objects.requireNonNull(outboundMessage, "OutboundMessage is required");
        OutboundMetaData outboundMetaData = outboundMessage.getOutboundMetaData();
        this.setProperty(AdapterPropertiesEnum.TRANSFER_ID.toString(), outboundMessage.getTransferId() == null ? this.generateTransferId() : outboundMessage.getTransferId().getStringValue());
        this.setDomainValueProperty(AdapterPropertiesEnum.CONTENT_LENGTH, (SerializeableDomainValue)outboundMetaData.getPayloadSize());
        this.setDomainValueProperty(MetaDataPropertiesEnum.MESSAGE_ID, (SerializeableDomainValue)outboundMetaData.getMessageId());
        this.setDomainValueProperty(MetaDataPropertiesEnum.CONVERSATION_ID, (SerializeableDomainValue)outboundMetaData.getConversationId());
        this.setDomainValueProperty(MetaDataPropertiesEnum.SEQUENCE_NUMBER, (SerializeableDomainValue)outboundMetaData.getSequenceNumber());
        this.setDomainValueProperty(MetaDataPropertiesEnum.SENDER_ID, (SerializeableDomainValue)outboundMetaData.getSenderId());
        this.setDomainValueProperty(MetaDataPropertiesEnum.RECEIVER_ID, (SerializeableDomainValue)outboundMetaData.getReceiverId());
        this.setDomainValueProperty(MetaDataPropertiesEnum.CREATION_TIME, (SerializeableDomainValue)outboundMetaData.getCreationTime());
        this.setDomainValueProperty(MetaDataPropertiesEnum.FILENAME, (SerializeableDomainValue)outboundMetaData.getOriginalFilename());
        this.setDomainValueProperty(MetaDataPropertiesEnum.LOG_INFO, (SerializeableDomainValue)outboundMetaData.getLogInfo());
        MessageType messageType = outboundMetaData.getMessageType();
        if (messageType != null) {
            this.setDomainValueProperty(MetaDataPropertiesEnum.MESSAGE_TYPE, (SerializeableDomainValue)messageType.getName());
            this.setDomainValueProperty(MetaDataPropertiesEnum.MESSAGE_VERSION, (SerializeableDomainValue)messageType.getVersion());
            this.setDomainValueProperty(MetaDataPropertiesEnum.SCHEMA_SET, (SerializeableDomainValue)messageType.getSchemaSet());
            this.setDomainValueProperty(MetaDataPropertiesEnum.MESSAGE_TYPE_DISPLAY_NAME, (SerializeableDomainValue)messageType.getDisplayName());
            this.setDomainValueProperty(MetaDataPropertiesEnum.MIME_TYPE, (SerializeableDomainValue)messageType.getMimeType());
        }
        TreeMap<String, String> processingDirectives = new TreeMap<String, String>();
        for (ProcessingDirective processingDirective : outboundMetaData.getProcessingDirectives().values()) {
            processingDirectives.put(processingDirective.getName(), processingDirective.getValue());
        }
        this.setProperties(MetaDataPropertiesEnum.PROCESSING_DIRECTIVE, processingDirectives);
    }

    private String generateTransferId() {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(secureRandom.generateSeed(10));
    }

    static {
        try {
            secureRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ProtocolOutboundMessageBuilder {
        private OutboundMessage outboundMessage;
        private boolean syncReply;

        public ProtocolOutboundMessageBuilder setOutboundMessage(OutboundMessage outboundMessage) {
            this.outboundMessage = outboundMessage;
            return this;
        }

        public ProtocolOutboundMessageBuilder setSyncReply(boolean syncReply) {
            this.syncReply = syncReply;
            return this;
        }

        public ProtocolOutboundMessage build() {
            return new ProtocolOutboundMessage(this.outboundMessage, this.syncReply);
        }
    }
}

