/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.TransmissionException;
import de.ponton.xp.adapter.api.domainvalues.TransferId;
import de.ponton.xp.adapter.api.internal.OutboundWebSocketConnection;
import de.ponton.xp.adapter.api.internal.WebSocketConnectionPool;
import de.ponton.xp.adapter.api.messages.OutboundMessage;
import de.ponton.xp.adapter.api.messages.OutboundMessageStatusUpdate;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class WebSocketConnectionBundle {
    private static final Logger LOG = Logger.getLogger(WebSocketConnectionBundle.class.getName());
    private final WebSocketConnectionPool outboundConnectionPool;
    private final WebSocketConnectionPool inboundConnectionPool;
    private final WebSocketConnectionPool archiveConnectionPool;
    private final AtomicBoolean receivingMessages = new AtomicBoolean();

    WebSocketConnectionBundle(WebSocketConnectionPool outboundConnectionPool, WebSocketConnectionPool inboundConnectionPool, WebSocketConnectionPool archiveConnectionPool) {
        this.outboundConnectionPool = outboundConnectionPool;
        this.inboundConnectionPool = inboundConnectionPool;
        this.archiveConnectionPool = archiveConnectionPool;
        this.outboundConnectionPool.setOnReconnect(() -> {
            if (this.receivingMessages.get()) {
                this.sendStartReception();
            }
            return null;
        });
    }

    public void sendStartReception() throws TransmissionException {
        OutboundWebSocketConnection outboundWebSocketConnection = (OutboundWebSocketConnection)this.outboundConnectionPool.borrowConnection();
        try {
            outboundWebSocketConnection.sendReadyForMessage();
            this.receivingMessages.set(true);
        }
        finally {
            this.outboundConnectionPool.releaseConnection(outboundWebSocketConnection);
        }
    }

    public void sendPauseReception() throws TransmissionException {
        OutboundWebSocketConnection outboundWebSocketConnection = (OutboundWebSocketConnection)this.outboundConnectionPool.borrowConnection();
        try {
            outboundWebSocketConnection.sendNotReadyForMessage();
            this.receivingMessages.set(false);
        }
        finally {
            this.outboundConnectionPool.releaseConnection(outboundWebSocketConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferId sendMessage(OutboundMessage message) throws TransmissionException {
        OutboundWebSocketConnection outboundWebSocketConnection = (OutboundWebSocketConnection)this.outboundConnectionPool.borrowConnection();
        try {
            TransferId transferId = outboundWebSocketConnection.sendMessage(message);
            return transferId;
        }
        finally {
            this.outboundConnectionPool.releaseConnection(outboundWebSocketConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundMessageStatusUpdate sendMessageSynchronously(OutboundMessage message) throws TransmissionException {
        OutboundWebSocketConnection outboundWebSocketConnection = (OutboundWebSocketConnection)this.outboundConnectionPool.borrowConnection();
        try {
            OutboundMessageStatusUpdate outboundMessageStatusUpdate = outboundWebSocketConnection.sendMessageSynchronously(message);
            return outboundMessageStatusUpdate;
        }
        finally {
            this.outboundConnectionPool.releaseConnection(outboundWebSocketConnection);
        }
    }

    public void close() {
        this.outboundConnectionPool.close();
        this.inboundConnectionPool.close();
        this.archiveConnectionPool.close();
    }
}

