/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class PontonThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final ClassLoader classLoader;

    public PontonThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Thread newThread(Runnable task) {
        Thread thread = new Thread(task, this.namePrefix + this.threadNumber.getAndIncrement());
        thread.setContextClassLoader(this.classLoader);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

