/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ConnectionException;
import de.ponton.xp.adapter.api.domainvalues.AdapterInfo;
import de.ponton.xp.adapter.api.internal.AbstractWebSocketEndpoint;
import de.ponton.xp.adapter.api.internal.OnCloseListener;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.security.Signer;
import de.ponton.xp.adapter.api.internal.security.UniqueId;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

class OutboundWebSocketEndpoint
extends AbstractWebSocketEndpoint {
    private static final Logger LOG = Logger.getLogger(OutboundWebSocketEndpoint.class.getName());
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private StringBuilder metaData;
    private int expectedContentLength;
    private CompletableFuture<SimpleProperties> responseExpected;
    private final OnCloseListener listener;

    OutboundWebSocketEndpoint(UniqueId uniqueId, Signer signer, AdapterInfo adapterInfo, OnCloseListener onCloseListener) {
        super(uniqueId, signer, adapterInfo, new CompletableFuture<SimpleProperties>());
        this.listener = onCloseListener;
        this.resetMetaData();
    }

    private void resetMetaData() {
        this.metaData = new StringBuilder();
    }

    @Override
    void handleOnText(WebSocket webSocket, CharSequence data, boolean last) {
        this.metaData.append(data);
        if (last) {
            SimpleProperties response = new SimpleProperties();
            response.load(this.metaData.toString());
            if (this.responseExpected != null) {
                this.responseExpected.complete(response);
            }
            this.resetMetaData();
        }
    }

    @Override
    void handleOnBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
    }

    @Override
    void handleOnClose(WebSocket webSocket, int statusCode, String reason) {
        if (this.responseExpected != null) {
            this.responseExpected.completeExceptionally(new ConnectionException(reason + " (" + statusCode + ")", null));
        }
        this.listener.onClose(webSocket);
    }

    CompletableFuture<SimpleProperties> expectResponse() {
        this.responseExpected = new CompletableFuture();
        return this.responseExpected;
    }
}

