/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.TransmissionException;
import de.ponton.xp.adapter.api.domainvalues.TransferId;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.OutboundWebSocketEndpoint;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.StatusUpdateResponseEnum;
import de.ponton.xp.adapter.api.internal.WebSocketConnection;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolNotReadyMessage;
import de.ponton.xp.adapter.api.internal.messages.ProtocolOutboundMessage;
import de.ponton.xp.adapter.api.internal.messages.ProtocolReadyMessage;
import de.ponton.xp.adapter.api.messages.OutboundMessage;
import de.ponton.xp.adapter.api.messages.OutboundMessageStatusUpdate;
import de.ponton.xp.adapter.api.messages.OutboundMessageStatusUpdateFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

public class OutboundWebSocketConnection
implements WebSocketConnection {
    private static final Logger LOG = Logger.getLogger(OutboundWebSocketConnection.class.getName());
    private final WebSocket outboundWebSocket;
    private final OutboundWebSocketEndpoint outboundWebSocketEndpoint;

    OutboundWebSocketConnection(WebSocket outboundWebSocket, OutboundWebSocketEndpoint outboundWebSocketEndpoint) {
        this.outboundWebSocket = outboundWebSocket;
        this.outboundWebSocketEndpoint = outboundWebSocketEndpoint;
    }

    public synchronized void sendReadyForMessage() throws TransmissionException {
        try {
            CompletableFuture<SimpleProperties> response = this.outboundWebSocketEndpoint.expectResponse();
            this.waitForWebSocketTransmission(this.outboundWebSocket.sendText(ProtocolReadyMessage.createBuilder().build().toWireFormat(), true));
            SimpleProperties properties = response.get();
            String messageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE);
            if (!ProtocolMessageTypeEnum.ReadyResponseMessage.name().equals(messageType)) {
                throw new TransmissionException("unexpected response " + messageType);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransmissionException("could not transmit message", e);
        }
        catch (IOException | ExecutionException e) {
            throw new TransmissionException("could not transmit message", e);
        }
    }

    public synchronized void sendNotReadyForMessage() throws TransmissionException {
        try {
            CompletableFuture<SimpleProperties> response = this.outboundWebSocketEndpoint.expectResponse();
            this.waitForWebSocketTransmission(this.outboundWebSocket.sendText(ProtocolNotReadyMessage.createBuilder().build().toWireFormat(), true));
            SimpleProperties properties = response.get();
            String messageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE);
            if (!ProtocolMessageTypeEnum.NotReadyResponseMessage.name().equals(messageType)) {
                throw new TransmissionException("unexpected response " + messageType);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransmissionException("could not transmit message", e);
        }
        catch (IOException | ExecutionException e) {
            throw new TransmissionException("could not transmit message", e);
        }
    }

    public OutboundMessageStatusUpdate sendMessageSynchronously(OutboundMessage message) throws TransmissionException {
        try {
            SimpleProperties properties = this.sendMessageAndWaitForResponse(message, true);
            String messageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE);
            if (ProtocolMessageTypeEnum.OutboundMessageStatusUpdate.name().equals(messageType)) {
                return OutboundMessageStatusUpdateFactory.getInstance().createOutboundMessageStatusUpdate(properties);
            }
            if (ProtocolMessageTypeEnum.OutboundMessageResponse.name().equals(messageType) && !properties.getProperty(AdapterPropertiesEnum.RESULT).equals(StatusUpdateResponseEnum.SUCCESS.name())) {
                throw new TransmissionException("Could not transmit the message. Result: " + properties.getProperty(AdapterPropertiesEnum.RESULT) + (String)(properties.containsProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT) ? " - Error: " + properties.getProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT) : ""));
            }
            throw new TransmissionException("unexpected response " + messageType);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransmissionException("could not transmit message", e);
        }
        catch (IOException | ExecutionException e) {
            throw new TransmissionException("could not transmit message", e);
        }
    }

    public synchronized TransferId sendMessage(OutboundMessage message) throws TransmissionException {
        try {
            SimpleProperties properties = this.sendMessageAndWaitForResponse(message, false);
            String messageType = properties.getProperty(AdapterPropertiesEnum.MESSAGE_TYPE);
            if (!ProtocolMessageTypeEnum.OutboundMessageResponse.name().equals(messageType)) {
                throw new TransmissionException("unexpected response " + messageType);
            }
            if (properties.getProperty(AdapterPropertiesEnum.RESULT).equals(StatusUpdateResponseEnum.SUCCESS.name())) {
                return new TransferId(properties.getProperty(AdapterPropertiesEnum.TRANSFER_ID));
            }
            throw new TransmissionException("Could not transmit the message. Result: " + properties.getProperty(AdapterPropertiesEnum.RESULT) + (String)(properties.containsProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT) ? " - Error: " + properties.getProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT) : ""));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransmissionException("could not transmit message", e);
        }
        catch (IOException | ExecutionException e) {
            throw new TransmissionException("could not transmit message", e);
        }
    }

    private SimpleProperties sendMessageAndWaitForResponse(OutboundMessage message, boolean syncReply) throws InterruptedException, ExecutionException, IOException {
        int totalSize = 0;
        ProtocolOutboundMessage protocolOutboundMessage = ProtocolOutboundMessage.createBuilder().setOutboundMessage(message).setSyncReply(syncReply).build();
        CompletableFuture<SimpleProperties> response = this.outboundWebSocketEndpoint.expectResponse();
        this.waitForWebSocketTransmission(this.outboundWebSocket.sendText(protocolOutboundMessage.toWireFormat(), true));
        byte[] buffer = new byte[8192];
        try (InputStream data = message.getInputStream();){
            int size = 0;
            while ((size = data.read(buffer)) > -1) {
                totalSize += size;
                this.waitForWebSocketTransmission(this.outboundWebSocket.sendBinary(ByteBuffer.wrap(buffer, 0, size), false));
            }
        }
        this.waitForWebSocketTransmission(this.outboundWebSocket.sendBinary(ByteBuffer.wrap(new byte[0]), true));
        LOG.finer("sent " + totalSize + " bytes on " + String.valueOf(this.outboundWebSocket));
        return response.get();
    }

    @Override
    public WebSocket getWebSocket() {
        return this.outboundWebSocket;
    }

    private void waitForWebSocketTransmission(CompletableFuture<WebSocket> future) throws InterruptedException, ExecutionException, IOException {
        WebSocket webSocket = future.get();
        if (webSocket.isOutputClosed() || webSocket.isInputClosed()) {
            throw new IOException("WebSocket is closed");
        }
    }

    @Override
    public void close() {
        this.outboundWebSocket.sendClose(1000, "shutdown");
    }
}

